/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="persist-report-project", aggregator=true, defaultPhase=LifecyclePhase.VALIDATE)
public class PersistProjectForReportMojo
extends AbstractMojo {
    @Parameter(property="easyjacoco.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="easyjacoco.reportGroupId")
    private String reportGroupId;
    @Parameter(property="easyjacoco.reportArtifactId")
    private String reportArtifactId;
    @Parameter(property="easyjacoco.reportVersion")
    private String reportVersion;
    @Parameter(property="easyjacoco.report.name")
    private String projectName;
    @Parameter(property="easyjacoco.report.description")
    private String projectDescription;
    @Parameter
    Properties projectExtraProperties;
    @Component
    private ModelWriter modelWriter;
    @Parameter(defaultValue="${maven.version}", readonly=true)
    private String mavenVersion;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Easy jacoco skipped via skip configuration");
            return;
        }
        Optional<MavenProject> projectOpt = this.session.getProjects().stream().filter(p -> this.reportGroupId.equals(p.getGroupId()) && this.reportArtifactId.equals(p.getArtifactId()) && this.reportVersion.equals(p.getVersion())).findFirst();
        if (projectOpt.isEmpty()) {
            throw new MojoExecutionException(String.format("Module not found %s:%s:%s", this.reportGroupId, this.reportArtifactId, this.reportVersion));
        }
        MavenProject project = projectOpt.get();
        if (project.getFile().exists()) {
            return;
        }
        project.getFile().getParentFile().mkdirs();
        Model model = project.getModel();
        if (this.isNotEmpty(this.projectName)) {
            model.setName(this.projectName);
        }
        if (this.isNotEmpty(this.projectDescription)) {
            model.setDescription(this.projectDescription);
        }
        try {
            this.modelWriter.write(project.getFile(), null, model);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        this.getLog().info((CharSequence)("Persisted generated project " + String.valueOf(project.getFile())));
    }

    private boolean isNotEmpty(Object obj) {
        return !PersistProjectForReportMojo.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            return ((Optional)obj).isEmpty();
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }
}

