/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco;

import com.marvinformatics.easyjacoco.RuleConfiguration;
import com.marvinformatics.easyjacoco.jacoco.FileFilter;
import com.marvinformatics.easyjacoco.jacoco.ReportSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;

@Mojo(name="check-project", defaultPhase=LifecyclePhase.VERIFY)
public class ProjectCheckMojo
extends AbstractMojo
implements IViolationsOutput {
    @Parameter(property="easyjacoco.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter
    private List<RuleConfiguration> projectRules;
    @Parameter(property="jacoco.haltOnFailure", defaultValue="false", required=true)
    private boolean haltOnFailure;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<String> dataFileIncludes;
    @Parameter
    private List<String> dataFileExcludes;
    @Parameter
    private List<String> excludeModules;
    private boolean violations;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Project check skipped via skip configuration");
            return;
        }
        this.getLog().info((CharSequence)"Running project wide check...");
        if (this.projectRules == null || this.projectRules.isEmpty()) {
            this.projectRules = new ArrayList<RuleConfiguration>();
            RuleConfiguration rule = new RuleConfiguration();
            rule.setElement("BUNDLE");
            ArrayList<Limit> limits = new ArrayList<Limit>();
            rule.setLimits(limits);
            Limit instructions = new Limit();
            instructions.setCounter(ICoverageNode.CounterEntity.INSTRUCTION.name());
            instructions.setValue(ICounter.CounterValue.COVEREDRATIO.name());
            instructions.setMinimum("0.80");
            limits.add(instructions);
            Limit classes = new Limit();
            classes.setCounter(ICoverageNode.CounterEntity.CLASS.name());
            classes.setValue(ICounter.CounterValue.MISSEDCOUNT.name());
            classes.setMaximum("0");
            limits.add(classes);
            this.projectRules.add(rule);
        }
        File projectRoot = this.session.getTopLevelProject().getBasedir();
        ReportSupport support = new ReportSupport(this.getLog());
        ArrayList<Rule> checkerrules = new ArrayList<Rule>();
        for (RuleConfiguration r : this.projectRules) {
            checkerrules.add(r.rule);
        }
        support.addRulesChecker(checkerrules, this);
        try {
            IReportVisitor visitor = support.initRootVisitor();
            this.loadExecutionData(support, projectRoot);
            support.processProjects((IReportGroupVisitor)visitor, this.session.getAllProjects(), this.includes, this.excludes, this.excludeModules);
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while checking code coverage: " + e.getMessage(), (Exception)e);
        }
        if (this.violations) {
            if (this.haltOnFailure) {
                throw new MojoExecutionException("Coverage checks have not been met. See log for details.");
            }
            this.getLog().warn((CharSequence)"Coverage checks have not been met. See log for details.");
        } else {
            this.getLog().info((CharSequence)"All coverage checks have been met.");
        }
    }

    void loadExecutionData(ReportSupport support, File projectRoot) throws IOException {
        FileFilter filter;
        List<File> files;
        if (this.dataFileIncludes == null) {
            this.dataFileIncludes = List.of("**/target/*.exec");
        }
        if ((files = (filter = new FileFilter(this.dataFileIncludes, this.dataFileExcludes)).getFiles(projectRoot)).isEmpty()) {
            this.getLog().error((CharSequence)String.format("No execution data found at: %s includes: %s excludes: %s", projectRoot, this.dataFileIncludes, this.dataFileExcludes));
        }
        for (File execFile : files) {
            support.loadExecutionData(execFile);
        }
    }

    public void onViolation(ICoverageNode node, Rule rule, Limit limit, String message) {
        this.getLog().warn((CharSequence)message);
        this.violations = true;
    }
}

