/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco;

import com.marvinformatics.easyjacoco.jacoco.FileFilter;
import com.marvinformatics.easyjacoco.jacoco.ReportFormat;
import com.marvinformatics.easyjacoco.jacoco.ReportSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;

@Mojo(name="report-project", defaultPhase=LifecyclePhase.VERIFY)
public class ProjectReportMojo
extends AbstractMojo {
    @Parameter(property="easyjacoco.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}/jacoco-project-report")
    private File outputDirectory;
    @Parameter(property="project.reporting.outputEncoding", defaultValue="UTF-8")
    private String outputEncoding;
    @Parameter(defaultValue="HTML,XML,CSV")
    private List<ReportFormat> formats;
    @Parameter(defaultValue="${project.name}")
    private String title;
    @Parameter
    String footer;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    private String sourceEncoding;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<String> dataFileIncludes;
    @Parameter
    private List<String> dataFileExcludes;
    @Parameter
    private List<String> excludeModules;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Project report aggregation skipped via skip configuration");
            return;
        }
        this.getLog().info((CharSequence)"Running project aggregation report...");
        File projectRoot = this.session.getTopLevelProject().getBasedir();
        try {
            ReportSupport support = new ReportSupport(this.getLog());
            this.loadExecutionData(support, projectRoot);
            this.outputDirectory.mkdirs();
            for (ReportFormat f : this.formats) {
                support.addVisitor(f.createVisitor(this.outputDirectory, this.outputEncoding, Locale.getDefault(), this.footer));
            }
            IReportVisitor visitor = support.initRootVisitor();
            this.createReport((IReportGroupVisitor)visitor, support);
            visitor.visitEnd();
            this.getLog().info((CharSequence)String.format("Project report available at: %s", this.outputDirectory));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while creating report: " + e.getMessage(), (Exception)e);
        }
    }

    void createReport(IReportGroupVisitor visitor, ReportSupport support) throws IOException {
        IReportGroupVisitor group = visitor.visitGroup(this.title);
        for (MavenProject project : this.session.getAllProjects()) {
            if (project.getPackaging().equals("pom")) continue;
            support.processProject(group, project.getArtifactId(), project, this.includes, this.excludes, this.sourceEncoding, this.excludeModules);
        }
    }

    void loadExecutionData(ReportSupport support, File projectRoot) throws IOException {
        if (this.dataFileIncludes == null) {
            this.dataFileIncludes = List.of("**/target/*.exec");
        }
        FileFilter filter = new FileFilter(this.dataFileIncludes, this.dataFileExcludes);
        for (File execFile : filter.getFiles(projectRoot)) {
            support.loadExecutionData(execFile);
        }
    }
}

