/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco.jacoco;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.core.internal.analysis.BundleCoverageImpl;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.SourceFileCoverageImpl;
import org.jacoco.core.internal.analysis.SourceNodeImpl;

public class CoverageBuilder
implements ICoverageVisitor {
    private final Map<String, IClassCoverage> classes;
    private Map<String, ISourceFileCoverage> sourcefiles;
    private final Log log;

    public CoverageBuilder(Log log) {
        this.log = log;
        this.classes = new HashMap<String, IClassCoverage>();
        this.sourcefiles = new HashMap<String, ISourceFileCoverage>();
    }

    public Collection<IClassCoverage> getClasses() {
        this.build();
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Collection<ISourceFileCoverage> getSourceFiles() {
        this.build();
        return Collections.unmodifiableCollection(this.sourcefiles.values());
    }

    public IBundleCoverage getBundle(String name) {
        this.build();
        return new BundleCoverageImpl(name, this.classes.values(), this.sourcefiles.values());
    }

    public Collection<IClassCoverage> getNoMatchClasses() {
        ArrayList<IClassCoverage> result = new ArrayList<IClassCoverage>();
        for (IClassCoverage c : this.classes.values()) {
            if (!c.isNoMatch()) continue;
            result.add(c);
        }
        return result;
    }

    private void build() {
        if (this.sourcefiles != null) {
            return;
        }
        this.sourcefiles = new HashMap<String, ISourceFileCoverage>();
        for (IClassCoverage c : this.classes.values()) {
            for (SourceNodeImpl fragment : ((ClassCoverageImpl)c).getFragments()) {
                SourceNodeImpl classCoverage = (SourceNodeImpl)this.classes.get(fragment.getName());
                if (classCoverage == null) continue;
                classCoverage.applyFragment(fragment);
            }
        }
        for (IClassCoverage coverage : this.classes.values()) {
            String source = coverage.getSourceFileName();
            if (source == null) continue;
            SourceFileCoverageImpl sourceFile = this.getSourceFile(source, coverage.getPackageName());
            sourceFile.increment((ISourceNode)coverage);
        }
    }

    public void visitCoverage(IClassCoverage coverage) {
        this.sourcefiles = null;
        String name = coverage.getName();
        IClassCoverage dup = this.classes.put(name, coverage);
        if (dup != null && dup.getId() != coverage.getId()) {
            this.log.warn((CharSequence)("Can't add different class with same name: " + name));
        }
    }

    private SourceFileCoverageImpl getSourceFile(String filename, String packagename) {
        String key = packagename + "/" + filename;
        SourceFileCoverageImpl sourcefile = (SourceFileCoverageImpl)this.sourcefiles.get(key);
        if (sourcefile == null) {
            sourcefile = new SourceFileCoverageImpl(filename, packagename);
            this.sourcefiles.put(key, (ISourceFileCoverage)sourcefile);
        }
        return sourcefile;
    }
}

