/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco.jacoco;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileFilter {
    private static final String DEFAULT_INCLUDES = "**";
    private static final String DEFAULT_EXCLUDES = "";
    private final List<String> includes;
    private final List<String> excludes;

    public FileFilter(List<String> includes, List<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public List<File> getFiles(File directory) throws IOException {
        return FileFilter.getFiles(directory, this.getIncludes(), this.getExcludes());
    }

    public static List<File> getFiles(File directory, String includes, String excludes) throws IOException {
        List<String> includePatterns = List.of(includes.split(","));
        List excludePatterns = excludes == null ? List.of() : List.of(excludes.split(","));
        Path basePath = directory.toPath();
        try (Stream<Path> stream = Files.walk(basePath, new FileVisitOption[0]);){
            List<File> list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> FileFilter.matches(basePath, path, includePatterns, true)).filter(path -> !FileFilter.matches(basePath, path, excludePatterns, false)).map(Path::toFile).collect(Collectors.toList());
            return list;
        }
    }

    private static boolean matches(Path basePath, Path path, List<String> patterns, boolean defaultIfEmpty) {
        if (patterns.isEmpty()) {
            return defaultIfEmpty;
        }
        String relativePath = basePath.relativize(path).toString().replace(File.separatorChar, '/');
        return patterns.stream().anyMatch(p -> relativePath.matches(FileFilter.globToRegex(p.trim())));
    }

    private static String globToRegex(String glob) {
        String regex = "^" + glob.replace(".", "\\.").replace(DEFAULT_INCLUDES, ".+").replace("*", "[^/]*") + "$";
        return regex;
    }

    public String getIncludes() {
        return this.buildPattern(this.includes, DEFAULT_INCLUDES);
    }

    public String getExcludes() {
        return this.buildPattern(this.excludes, DEFAULT_EXCLUDES);
    }

    private String buildPattern(List<String> patterns, String defaultPattern) {
        String pattern = defaultPattern;
        if (patterns != null && !patterns.isEmpty()) {
            pattern = patterns.stream().collect(Collectors.joining(","));
        }
        return pattern;
    }
}

