/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco.jacoco;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public enum ReportFormat {
    HTML{

        @Override
        public IReportVisitor createVisitor(File outputDirectory, String outputEncoding, Locale locale, String footer) throws IOException {
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setOutputEncoding(outputEncoding);
            htmlFormatter.setLocale(locale);
            if (footer != null) {
                htmlFormatter.setFooterText(footer);
            }
            return htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(outputDirectory));
        }
    }
    ,
    XML{

        @Override
        public IReportVisitor createVisitor(File outputDirectory, String outputEncoding, Locale locale, String footer) throws IOException {
            XMLFormatter xml = new XMLFormatter();
            xml.setOutputEncoding(outputEncoding);
            return xml.createVisitor((OutputStream)new FileOutputStream(new File(outputDirectory, "jacoco.xml")));
        }
    }
    ,
    CSV{

        @Override
        public IReportVisitor createVisitor(File outputDirectory, String outputEncoding, Locale locale, String footer) throws IOException {
            CSVFormatter csv = new CSVFormatter();
            csv.setOutputEncoding(outputEncoding);
            return csv.createVisitor((OutputStream)new FileOutputStream(new File(outputDirectory, "jacoco.csv")));
        }
    };


    public abstract IReportVisitor createVisitor(File var1, String var2, Locale var3, String var4) throws IOException;
}

