/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco.jacoco;

import com.marvinformatics.easyjacoco.jacoco.CoverageBuilder;
import com.marvinformatics.easyjacoco.jacoco.FileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Rule;
import org.jacoco.report.check.RulesChecker;

public class ReportSupport {
    private final Log log;
    private final ExecFileLoader loader;
    private final List<IReportVisitor> formatters;

    public ReportSupport(Log log) {
        this.log = log;
        this.loader = new ExecFileLoader();
        this.formatters = new ArrayList<IReportVisitor>();
    }

    public void loadExecutionData(File execFile) throws IOException {
        this.log.info((CharSequence)("Loading execution data file " + String.valueOf(execFile)));
        this.loader.load(execFile);
    }

    public void addVisitor(IReportVisitor visitor) {
        this.formatters.add(visitor);
    }

    public void addRulesChecker(List<Rule> rules, IViolationsOutput output) {
        RulesChecker checker = new RulesChecker();
        checker.setRules(rules);
        this.formatters.add(checker.createVisitor(output));
    }

    public IReportVisitor initRootVisitor() throws IOException {
        MultiReportVisitor visitor = new MultiReportVisitor(this.formatters);
        visitor.visitInfo(this.loader.getSessionInfoStore().getInfos(), this.loader.getExecutionDataStore().getContents());
        return visitor;
    }

    public void processProjects(IReportGroupVisitor visitor, List<MavenProject> projects, List<String> includes, List<String> excludes, List<String> excludedModules) throws IOException {
        this.processProjects(visitor, projects, includes, excludes, new NoSourceLocator(), "project", excludedModules);
    }

    public void processProject(IReportGroupVisitor visitor, String bundleName, MavenProject project, List<String> includes, List<String> excludes, String srcEncoding, List<String> excludedModules) throws IOException {
        this.processProject(visitor, bundleName, project, includes, excludes, new SourceFileCollection(project, srcEncoding), excludedModules);
    }

    private void processProjects(IReportGroupVisitor visitor, List<MavenProject> projects, List<String> includes, List<String> excludes, ISourceFileLocator locator, String bundleName, List<String> excludedModules) throws IOException {
        CoverageBuilder builder = new CoverageBuilder(this.log);
        excludedModules = excludedModules == null ? Collections.emptyList() : excludedModules;
        for (MavenProject project : projects) {
            File classesDir = new File(project.getBuild().getOutputDirectory());
            if (excludedModules.contains(project.getArtifactId())) {
                this.log.debug((CharSequence)String.format("Module '%s' skipped due to excludedModules %s", project, excludedModules));
                continue;
            }
            if (!classesDir.isDirectory()) continue;
            Analyzer analyzer = new Analyzer(this.loader.getExecutionDataStore(), (ICoverageVisitor)builder);
            FileFilter filter = new FileFilter(includes, excludes);
            for (File file : filter.getFiles(classesDir)) {
                analyzer.analyzeAll(file);
            }
        }
        IBundleCoverage bundle = builder.getBundle(bundleName);
        this.logBundleInfo(bundle, builder.getNoMatchClasses());
        visitor.visitBundle(bundle, locator);
    }

    private void processProject(IReportGroupVisitor visitor, String bundleName, MavenProject project, List<String> includes, List<String> excludes, ISourceFileLocator locator, List<String> excludedModules) throws IOException {
        this.processProjects(visitor, Collections.singletonList(project), includes, excludes, locator, project.getName(), excludedModules);
    }

    private void logBundleInfo(IBundleCoverage bundle, Collection<IClassCoverage> nomatch) {
        this.log.info((CharSequence)String.format("Analyzed bundle '%s' with %s classes", bundle.getName(), bundle.getClassCounter().getTotalCount()));
        if (!nomatch.isEmpty()) {
            this.log.warn((CharSequence)String.format("Classes in bundle '%s' do not match with execution data. For report generation the same class files must be used as at runtime.", bundle.getName()));
            for (IClassCoverage c : nomatch) {
                this.log.warn((CharSequence)String.format("Execution data for class %s does not match.", c.getName()));
            }
        }
        if (bundle.containsCode() && bundle.getLineCounter().getTotalCount() == 0) {
            this.log.warn((CharSequence)"To enable source code annotation class files have to be compiled with debug information.");
        }
    }

    private static List<File> getCompileSourceRoots(MavenProject project) {
        ArrayList<File> result = new ArrayList<File>();
        for (Object path : project.getCompileSourceRoots()) {
            result.add(ReportSupport.resolvePath(project, (String)path));
        }
        return result;
    }

    private static File resolvePath(MavenProject project, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(project.getBasedir(), path);
        }
        return file;
    }

    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final List<File> sourceRoots;
        private final String encoding;

        public SourceFileCollection(MavenProject project, String encoding) {
            this.sourceRoots = ReportSupport.getCompileSourceRoots(project);
            this.encoding = encoding;
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            Object r = packageName.length() > 0 ? packageName + "/" + fileName : fileName;
            for (File sourceRoot : this.sourceRoots) {
                File file = new File(sourceRoot, (String)r);
                if (!file.exists() || !file.isFile()) continue;
                return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            }
            return null;
        }

        public int getTabWidth() {
            return 4;
        }
    }

    private static class NoSourceLocator
    implements ISourceFileLocator {
        private NoSourceLocator() {
        }

        public Reader getSourceFile(String packageName, String fileName) {
            return null;
        }

        public int getTabWidth() {
            return 0;
        }
    }
}

