/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.http;

import com.mashape.unirest.http.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse<T> {
    private int code;
    private Map<String, String> headers;
    private InputStream rawBody;
    private T body;

    public HttpResponse(org.apache.http.HttpResponse response, Class<T> responseClass) {
        block9: {
            HttpEntity responseEntity = response.getEntity();
            Header[] allHeaders = response.getAllHeaders();
            this.headers = new HashMap<String, String>();
            for (Header header : allHeaders) {
                this.headers.put(header.getName().toLowerCase(), header.getValue());
            }
            this.code = response.getStatusLine().getStatusCode();
            if (responseEntity != null) {
                try {
                    byte[] rawBody;
                    try {
                        rawBody = HttpResponse.getBytes(responseEntity.getContent());
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(rawBody);
                    this.rawBody = inputStream;
                    if (JsonNode.class.equals(responseClass)) {
                        String jsonString = new String(rawBody).trim();
                        this.body = new JsonNode(jsonString);
                        break block9;
                    }
                    if (String.class.equals(responseClass)) {
                        this.body = new String(rawBody);
                        break block9;
                    }
                    if (InputStream.class.equals(responseClass)) {
                        this.body = this.rawBody;
                        break block9;
                    }
                    throw new Exception("Unknown result type. Only String, JsonNode and InputStream are supported.");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            int len = is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        return this.rawBody;
    }

    public T getBody() {
        return this.body;
    }
}

