/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaseFiling extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("9d0ddac3-404a-42cf-a336-ce2580ca4cf9", new OperationConfig("/mastercom/v6/cases", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("9192e692-2f41-4b00-83c5-39e380a95605", new OperationConfig("/mastercom/v6/cases/{case-id}/documents", Action.query, Arrays.asList("format","memo"), Arrays.asList("")));
        operationConfigs.put("95b66821-9ed7-4521-9b20-ae7a78e09061", new OperationConfig("/mastercom/v6/cases/imagestatus", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("2ef7cf56-bbed-46b3-867f-18748530b4a3", new OperationConfig("/mastercom/v6/cases/status", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("2d00c78f-a61c-44e5-95c6-dec704499610", new OperationConfig("/mastercom/v6/cases/retrieve/claims", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("f2026b1f-7a85-4010-b9ea-485afbf720c4", new OperationConfig("/mastercom/v6/cases/{case-id}", Action.update, Arrays.asList(""), Arrays.asList("")));
    }

    public CaseFiling() {
    }

    public CaseFiling(BaseObject o) {
        putAll(o);
    }

    public CaseFiling(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

  /**
   * Creates a <code>CaseFiling</code> object
   *
   * @param map a map of parameters to create a <code>CaseFiling</code> object
   *
   * @return a CaseFiling object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static CaseFiling create(RequestMap map)
    throws ApiException {

    return create(null, map);
  }

  /**
   * Creates a <code>CaseFiling</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>CaseFiling</code> object
   *
   * @return a CaseFiling object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static CaseFiling create(Authentication auth, RequestMap map)
    throws ApiException {

    return new CaseFiling(BaseObject.executeOperation(auth, "9d0ddac3-404a-42cf-a336-ce2580ca4cf9", new CaseFiling(map)));
  }











    /**
     * Query / Retrieve a <code>CaseFiling</code> object
     *
     * @param query a map of query parameters
     *
     * @return a CaseFiling object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static CaseFiling retrieveDocumentation(RequestMap query)
        throws ApiException {

        return retrieveDocumentation(null, query);
    }

    /**
     * Query / Retrieve a <code>CaseFiling</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param query a map of query parameters
     *
     * @return a CaseFiling object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static CaseFiling retrieveDocumentation(Authentication auth, RequestMap query)
        throws ApiException {

        CaseFiling val = new CaseFiling();
        if (query != null)  val.putAll(query);
        return new CaseFiling(BaseObject.executeOperation(auth, "9192e692-2f41-4b00-83c5-39e380a95605", val));
    }

    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling caseFilingImageStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "95b66821-9ed7-4521-9b20-ae7a78e09061", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling caseFilingImageStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "95b66821-9ed7-4521-9b20-ae7a78e09061", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling caseFilingStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "2ef7cf56-bbed-46b3-867f-18748530b4a3", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling caseFilingStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "2ef7cf56-bbed-46b3-867f-18748530b4a3", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling retrieve()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "2d00c78f-a61c-44e5-95c6-dec704499610", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling retrieve(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "2d00c78f-a61c-44e5-95c6-dec704499610", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling update()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "f2026b1f-7a85-4010-b9ea-485afbf720c4", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>CaseFiling</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a CaseFiling object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public CaseFiling update(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "f2026b1f-7a85-4010-b9ea-485afbf720c4", this);
        this.putAll(object);
        return this;
    }




}


