/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chargebacks extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("5c5b725c-4fcc-4d26-8790-386905f50be7", new OperationConfig("/mastercom/v6/chargebacks/acknowledge", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("b36dc0d8-12f1-45c2-8498-3d946bcab6ac", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("04adc3e0-e3d7-4221-a547-16b8c07ac4f6", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/{chargeback-id}/reversal", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("b4deba40-6f1e-4c51-a274-622279104314", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/{chargeback-id}/documents", Action.query, Arrays.asList("format"), Arrays.asList("")));
        operationConfigs.put("51ae6ba8-0be1-4652-92db-5cc7ee9f71eb", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/loaddataforchargebacks", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("5cbab87a-120c-4b54-9df9-b8c802a4d7e5", new OperationConfig("/mastercom/v6/chargebacks/imagestatus", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("50b1192d-f40f-4587-9205-0cdcd91c6fd3", new OperationConfig("/mastercom/v6/chargebacks/status", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("70e4f540-611c-4953-8442-aa81a6ed3dba", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/{chargeback-id}", Action.update, Arrays.asList(""), Arrays.asList("")));
    }

    public Chargebacks() {
    }

    public Chargebacks(BaseObject o) {
        putAll(o);
    }

    public Chargebacks(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }


    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks acknowledgeReceivedChargebacks()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "5c5b725c-4fcc-4d26-8790-386905f50be7", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks acknowledgeReceivedChargebacks(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "5c5b725c-4fcc-4d26-8790-386905f50be7", this);
        this.putAll(object);
        return this;
    }




  /**
   * Creates a <code>Chargebacks</code> object
   *
   * @param map a map of parameters to create a <code>Chargebacks</code> object
   *
   * @return a Chargebacks object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Chargebacks create(RequestMap map)
    throws ApiException {

    return create(null, map);
  }

  /**
   * Creates a <code>Chargebacks</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Chargebacks</code> object
   *
   * @return a Chargebacks object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Chargebacks create(Authentication auth, RequestMap map)
    throws ApiException {

    return new Chargebacks(BaseObject.executeOperation(auth, "b36dc0d8-12f1-45c2-8498-3d946bcab6ac", new Chargebacks(map)));
  }






  /**
   * Creates a <code>Chargebacks</code> object
   *
   * @param map a map of parameters to create a <code>Chargebacks</code> object
   *
   * @return a Chargebacks object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Chargebacks createReversal(RequestMap map)
    throws ApiException {

    return createReversal(null, map);
  }

  /**
   * Creates a <code>Chargebacks</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Chargebacks</code> object
   *
   * @return a Chargebacks object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Chargebacks createReversal(Authentication auth, RequestMap map)
    throws ApiException {

    return new Chargebacks(BaseObject.executeOperation(auth, "04adc3e0-e3d7-4221-a547-16b8c07ac4f6", new Chargebacks(map)));
  }











    /**
     * Query / Retrieve a <code>Chargebacks</code> object
     *
     * @param query a map of query parameters
     *
     * @return a Chargebacks object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Chargebacks retrieveDocumentation(RequestMap query)
        throws ApiException {

        return retrieveDocumentation(null, query);
    }

    /**
     * Query / Retrieve a <code>Chargebacks</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param query a map of query parameters
     *
     * @return a Chargebacks object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Chargebacks retrieveDocumentation(Authentication auth, RequestMap query)
        throws ApiException {

        Chargebacks val = new Chargebacks();
        if (query != null)  val.putAll(query);
        return new Chargebacks(BaseObject.executeOperation(auth, "b4deba40-6f1e-4c51-a274-622279104314", val));
    }
  /**
   * Creates a <code>Chargebacks</code> object
   *
   * @param map a map of parameters to create a <code>Chargebacks</code> object
   *
   * @return a Chargebacks object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Chargebacks getPossibleValueListsForCreate(RequestMap map)
    throws ApiException {

    return getPossibleValueListsForCreate(null, map);
  }

  /**
   * Creates a <code>Chargebacks</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Chargebacks</code> object
   *
   * @return a Chargebacks object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Chargebacks getPossibleValueListsForCreate(Authentication auth, RequestMap map)
    throws ApiException {

    return new Chargebacks(BaseObject.executeOperation(auth, "51ae6ba8-0be1-4652-92db-5cc7ee9f71eb", new Chargebacks(map)));
  }







    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks chargebacksImageStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "5cbab87a-120c-4b54-9df9-b8c802a4d7e5", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks chargebacksImageStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "5cbab87a-120c-4b54-9df9-b8c802a4d7e5", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks chargebacksStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "50b1192d-f40f-4587-9205-0cdcd91c6fd3", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks chargebacksStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "50b1192d-f40f-4587-9205-0cdcd91c6fd3", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks update()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "70e4f540-611c-4953-8442-aa81a6ed3dba", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Chargebacks</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Chargebacks object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Chargebacks update(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "70e4f540-611c-4953-8442-aa81a6ed3dba", this);
        this.putAll(object);
        return this;
    }




}


