/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChargebacksDebitMasterCardAndEuropeDualAcquirer extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("47f563ab-b519-4485-a51d-27a6340716aa", new OperationConfig("/mastercom/v6/chargebacks/debitmc/acknowledge", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("d70b6488-23a5-4a3b-a2d7-5ae032e80107", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/debitmc", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("b0c5086e-75e2-411b-8595-9d9c4b2ec1f9", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/debitmc/{chargeback-id}/reversal", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("e8089035-a82b-48fa-978a-2f2f82bfbf8b", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/debitmc/{chargeback-id}/documents", Action.query, Arrays.asList("format"), Arrays.asList("")));
        operationConfigs.put("b66299fc-052d-4cf0-8ae5-c650fa64f6be", new OperationConfig("/mastercom/v6/chargebacks/debitmc/imagestatus", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("42ec326c-fc4f-4a46-858e-fe35ea0e5ee1", new OperationConfig("/mastercom/v6/chargebacks/debitmc/status", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("0c73bb76-f0e2-4250-b46b-cbbd547c101a", new OperationConfig("/mastercom/v6/claims/{claim-id}/chargebacks/debitmc/{chargeback-id}", Action.update, Arrays.asList(""), Arrays.asList("")));
    }

    public ChargebacksDebitMasterCardAndEuropeDualAcquirer() {
    }

    public ChargebacksDebitMasterCardAndEuropeDualAcquirer(BaseObject o) {
        putAll(o);
    }

    public ChargebacksDebitMasterCardAndEuropeDualAcquirer(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }


    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer acknowledgeReceivedChargebacks()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "47f563ab-b519-4485-a51d-27a6340716aa", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer acknowledgeReceivedChargebacks(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "47f563ab-b519-4485-a51d-27a6340716aa", this);
        this.putAll(object);
        return this;
    }




  /**
   * Creates a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param map a map of parameters to create a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static ChargebacksDebitMasterCardAndEuropeDualAcquirer create(RequestMap map)
    throws ApiException {

    return create(null, map);
  }

  /**
   * Creates a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static ChargebacksDebitMasterCardAndEuropeDualAcquirer create(Authentication auth, RequestMap map)
    throws ApiException {

    return new ChargebacksDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "d70b6488-23a5-4a3b-a2d7-5ae032e80107", new ChargebacksDebitMasterCardAndEuropeDualAcquirer(map)));
  }






  /**
   * Creates a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param map a map of parameters to create a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static ChargebacksDebitMasterCardAndEuropeDualAcquirer createReversal(RequestMap map)
    throws ApiException {

    return createReversal(null, map);
  }

  /**
   * Creates a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static ChargebacksDebitMasterCardAndEuropeDualAcquirer createReversal(Authentication auth, RequestMap map)
    throws ApiException {

    return new ChargebacksDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "b0c5086e-75e2-411b-8595-9d9c4b2ec1f9", new ChargebacksDebitMasterCardAndEuropeDualAcquirer(map)));
  }











    /**
     * Query / Retrieve a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
     *
     * @param query a map of query parameters
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static ChargebacksDebitMasterCardAndEuropeDualAcquirer retrieveDocumentation(RequestMap query)
        throws ApiException {

        return retrieveDocumentation(null, query);
    }

    /**
     * Query / Retrieve a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param query a map of query parameters
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static ChargebacksDebitMasterCardAndEuropeDualAcquirer retrieveDocumentation(Authentication auth, RequestMap query)
        throws ApiException {

        ChargebacksDebitMasterCardAndEuropeDualAcquirer val = new ChargebacksDebitMasterCardAndEuropeDualAcquirer();
        if (query != null)  val.putAll(query);
        return new ChargebacksDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "e8089035-a82b-48fa-978a-2f2f82bfbf8b", val));
    }

    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer chargebacksImageStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "b66299fc-052d-4cf0-8ae5-c650fa64f6be", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer chargebacksImageStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "b66299fc-052d-4cf0-8ae5-c650fa64f6be", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer chargebacksStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "42ec326c-fc4f-4a46-858e-fe35ea0e5ee1", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer chargebacksStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "42ec326c-fc4f-4a46-858e-fe35ea0e5ee1", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer update()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "0c73bb76-f0e2-4250-b46b-cbbd547c101a", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>ChargebacksDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a ChargebacksDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public ChargebacksDebitMasterCardAndEuropeDualAcquirer update(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "0c73bb76-f0e2-4250-b46b-cbbd547c101a", this);
        this.putAll(object);
        return this;
    }




}


