/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Claims extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("e999f396-5078-4aad-aef8-36731da3ac88", new OperationConfig("/mastercom/v6/claims", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("00ae4526-c57a-40e8-b454-4a081b00d716", new OperationConfig("/mastercom/v6/claims/{claim-id}", Action.read, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("6a0391f1-8b5e-49eb-a972-1a893b115e2a", new OperationConfig("/mastercom/v6/claims/{claim-id}", Action.update, Arrays.asList(""), Arrays.asList("")));
    }

    public Claims() {
    }

    public Claims(BaseObject o) {
        putAll(o);
    }

    public Claims(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

  /**
   * Creates a <code>Claims</code> object
   *
   * @param map a map of parameters to create a <code>Claims</code> object
   *
   * @return a Claims object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Claims create(RequestMap map)
    throws ApiException {

    return create(null, map);
  }

  /**
   * Creates a <code>Claims</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Claims</code> object
   *
   * @return a Claims object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Claims create(Authentication auth, RequestMap map)
    throws ApiException {

    return new Claims(BaseObject.executeOperation(auth, "e999f396-5078-4aad-aef8-36731da3ac88", new Claims(map)));
  }










    /**
     * Retrieve a <code>Claims</code> object
     *
     * @param id the id of the <code>Claims</code> object to retrieve
     *
     * @return a Claims object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Claims retrieve(String id)
        throws ApiException {

        return retrieve(null, id, null);
    }

    /**
     * Retrieve a <code>Claims</code> object
     *
     * @param id the id of the <code>Claims</code> object to retrieve
     * @param map a map of additional parameters
     *
     * @return a Claims object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Claims retrieve(String id, RequestMap map)
        throws ApiException {

        return retrieve(null, id, map);
    }

    /**
     * Retrieve a <code>Claims</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param id the id of the <code>Claims</code> object to retrieve
     *
     * @return a Claims object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Claims retrieve(Authentication auth, String id)
        throws ApiException {

        return retrieve(auth, id, null);
    }

    /**
     * Retrieve a <code>Claims</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param id the id of the <code>Claims</code> object to retrieve
     * @param map a map of additional parameters
     *
     * @return a Claims object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Claims retrieve(Authentication auth, String id, RequestMap map)
        throws ApiException {

        Claims val = new Claims();
        if (id != null) val.put("id", id);
        if (map != null)  val.putAll(map);
        return new Claims(BaseObject.executeOperation(auth, "00ae4526-c57a-40e8-b454-4a081b00d716", val));
    }


    /**
     * Update a <code>Claims</code> object.
     *
     * @return a Claims object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Claims update()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "6a0391f1-8b5e-49eb-a972-1a893b115e2a", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Claims</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Claims object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Claims update(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "6a0391f1-8b5e-49eb-a972-1a893b115e2a", this);
        this.putAll(object);
        return this;
    }




}


