/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Queues extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("ccbcf795-1936-4006-a57e-5fcb097e7a6b", new OperationConfig("/mastercom/v6/queues", Action.list, Arrays.asList("queue-name"), Arrays.asList("")));
        operationConfigs.put("517eebac-7b62-460f-86f9-1e898e87ddf7", new OperationConfig("/mastercom/v6/queues", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("609c0a7e-14ca-4460-9047-2fffd5615649", new OperationConfig("/mastercom/v6/queues/names", Action.list, Arrays.asList(""), Arrays.asList("")));
    }

    public Queues() {
    }

    public Queues(BaseObject o) {
        putAll(o);
    }

    public Queues(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }



  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects and the total
   *              number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveClaimsFromQueue()
    throws ApiException {

    return BaseObject.executeListOperation(null, "ccbcf795-1936-4006-a57e-5fcb097e7a6b", new Queues(), null);
  }

  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects and the total
   *              number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveClaimsFromQueue(Authentication auth)
    throws ApiException {

    return BaseObject.executeListOperation(auth, "ccbcf795-1936-4006-a57e-5fcb097e7a6b", new Queues(), null);
  }

  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @param criteria a map of additional criteria parameters
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects based on the
   *              <code>criteria</code> provided  and the total number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveClaimsFromQueue(RequestMap criteria)
    throws ApiException {

    return BaseObject.executeListOperation(null, "ccbcf795-1936-4006-a57e-5fcb097e7a6b", new Queues(), criteria);
  }

  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param criteria a map of additional criteria parameters
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects based on the
   *              <code>criteria</code> provided and the total number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveClaimsFromQueue(Authentication auth, RequestMap criteria)
    throws ApiException {

    return BaseObject.executeListOperation(auth, "ccbcf795-1936-4006-a57e-5fcb097e7a6b", new Queues(), criteria);
  }



  /**
   * Creates a <code>Queues</code> object
   *
   * @param map a map of parameters to create a <code>Queues</code> object
   *
   * @return a Queues object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Queues retrieveClaimsFromQueueWithDateInterval(RequestMap map)
    throws ApiException {

    return retrieveClaimsFromQueueWithDateInterval(null, map);
  }

  /**
   * Creates a <code>Queues</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Queues</code> object
   *
   * @return a Queues object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Queues retrieveClaimsFromQueueWithDateInterval(Authentication auth, RequestMap map)
    throws ApiException {

    return new Queues(BaseObject.executeOperation(auth, "517eebac-7b62-460f-86f9-1e898e87ddf7", new Queues(map)));
  }








  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects and the total
   *              number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveQueueNames()
    throws ApiException {

    return BaseObject.executeListOperation(null, "609c0a7e-14ca-4460-9047-2fffd5615649", new Queues(), null);
  }

  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects and the total
   *              number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveQueueNames(Authentication auth)
    throws ApiException {

    return BaseObject.executeListOperation(auth, "609c0a7e-14ca-4460-9047-2fffd5615649", new Queues(), null);
  }

  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @param criteria a map of additional criteria parameters
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects based on the
   *              <code>criteria</code> provided  and the total number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveQueueNames(RequestMap criteria)
    throws ApiException {

    return BaseObject.executeListOperation(null, "609c0a7e-14ca-4460-9047-2fffd5615649", new Queues(), criteria);
  }

  /**
   * Retrieve a list of <code>Queues</code> objects
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param criteria a map of additional criteria parameters
   *
   * @return a ResourceList&lt;Queues&gt; object which holds the list of Queues objects based on the
   *              <code>criteria</code> provided and the total number of Queues objects available.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   *
   * @see ResourceList
   */
  public static ResourceList<Queues> retrieveQueueNames(Authentication auth, RequestMap criteria)
    throws ApiException {

    return BaseObject.executeListOperation(auth, "609c0a7e-14ca-4460-9047-2fffd5615649", new Queues(), criteria);
  }



}


