/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Reconciliation extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("fa79ef39-1c4b-4cc8-9ea8-4ffad34be93b", new OperationConfig("/mastercom/v6/reconreport/data/request", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("24e03f80-1084-404d-b663-b7dcb2306fd4", new OperationConfig("/mastercom/v6/reconreport/data/retrieval/{reportIdentifier}", Action.create, Arrays.asList(""), Arrays.asList("")));
    }

    public Reconciliation() {
    }

    public Reconciliation(BaseObject o) {
        putAll(o);
    }

    public Reconciliation(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

  /**
   * Creates a <code>Reconciliation</code> object
   *
   * @param map a map of parameters to create a <code>Reconciliation</code> object
   *
   * @return a Reconciliation object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Reconciliation acknowledgeReconciliationRequest(RequestMap map)
    throws ApiException {

    return acknowledgeReconciliationRequest(null, map);
  }

  /**
   * Creates a <code>Reconciliation</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Reconciliation</code> object
   *
   * @return a Reconciliation object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Reconciliation acknowledgeReconciliationRequest(Authentication auth, RequestMap map)
    throws ApiException {

    return new Reconciliation(BaseObject.executeOperation(auth, "fa79ef39-1c4b-4cc8-9ea8-4ffad34be93b", new Reconciliation(map)));
  }






  /**
   * Creates a <code>Reconciliation</code> object
   *
   * @param map a map of parameters to create a <code>Reconciliation</code> object
   *
   * @return a Reconciliation object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Reconciliation retrieveReconciliationReport(RequestMap map)
    throws ApiException {

    return retrieveReconciliationReport(null, map);
  }

  /**
   * Creates a <code>Reconciliation</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Reconciliation</code> object
   *
   * @return a Reconciliation object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Reconciliation retrieveReconciliationReport(Authentication auth, RequestMap map)
    throws ApiException {

    return new Reconciliation(BaseObject.executeOperation(auth, "24e03f80-1084-404d-b663-b7dcb2306fd4", new Reconciliation(map)));
  }






}


