/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Retrievals extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("f092ddaa-15d1-4157-8f8b-bdf7efd87484", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/{request-id}/fulfillments", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("b6941ad0-b42c-48f4-b577-c0dfd8aee1eb", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("528b4abd-ecb9-4cf9-b7cd-d4e46543b4b9", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/loaddataforretrievalrequests", Action.query, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("a5c0a117-4fba-426d-8e91-e0c2b0967b52", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/{request-id}/documents", Action.query, Arrays.asList("format"), Arrays.asList("")));
        operationConfigs.put("fa003814-6275-4aae-97a4-61c203933fe8", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/{request-id}/fulfillments/response", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("06ca5c57-6e18-4743-9f13-da1ee6a954a6", new OperationConfig("/mastercom/v6/retrievalrequests/imagestatus", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("c1fcb452-f007-470d-b0c9-16f881033a1c", new OperationConfig("/mastercom/v6/retrievalrequests/status", Action.update, Arrays.asList(""), Arrays.asList("")));
    }

    public Retrievals() {
    }

    public Retrievals(BaseObject o) {
        putAll(o);
    }

    public Retrievals(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

  /**
   * Creates a <code>Retrievals</code> object
   *
   * @param map a map of parameters to create a <code>Retrievals</code> object
   *
   * @return a Retrievals object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Retrievals acquirerFulfillARequest(RequestMap map)
    throws ApiException {

    return acquirerFulfillARequest(null, map);
  }

  /**
   * Creates a <code>Retrievals</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Retrievals</code> object
   *
   * @return a Retrievals object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Retrievals acquirerFulfillARequest(Authentication auth, RequestMap map)
    throws ApiException {

    return new Retrievals(BaseObject.executeOperation(auth, "f092ddaa-15d1-4157-8f8b-bdf7efd87484", new Retrievals(map)));
  }






  /**
   * Creates a <code>Retrievals</code> object
   *
   * @param map a map of parameters to create a <code>Retrievals</code> object
   *
   * @return a Retrievals object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Retrievals create(RequestMap map)
    throws ApiException {

    return create(null, map);
  }

  /**
   * Creates a <code>Retrievals</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Retrievals</code> object
   *
   * @return a Retrievals object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Retrievals create(Authentication auth, RequestMap map)
    throws ApiException {

    return new Retrievals(BaseObject.executeOperation(auth, "b6941ad0-b42c-48f4-b577-c0dfd8aee1eb", new Retrievals(map)));
  }











    /**
     * Query / Retrieve a <code>Retrievals</code> object
     *
     * @param query a map of query parameters
     *
     * @return a Retrievals object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Retrievals getPossibleValueListsForCreate(RequestMap query)
        throws ApiException {

        return getPossibleValueListsForCreate(null, query);
    }

    /**
     * Query / Retrieve a <code>Retrievals</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param query a map of query parameters
     *
     * @return a Retrievals object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Retrievals getPossibleValueListsForCreate(Authentication auth, RequestMap query)
        throws ApiException {

        Retrievals val = new Retrievals();
        if (query != null)  val.putAll(query);
        return new Retrievals(BaseObject.executeOperation(auth, "528b4abd-ecb9-4cf9-b7cd-d4e46543b4b9", val));
    }





    /**
     * Query / Retrieve a <code>Retrievals</code> object
     *
     * @param query a map of query parameters
     *
     * @return a Retrievals object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Retrievals getDocumentation(RequestMap query)
        throws ApiException {

        return getDocumentation(null, query);
    }

    /**
     * Query / Retrieve a <code>Retrievals</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param query a map of query parameters
     *
     * @return a Retrievals object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Retrievals getDocumentation(Authentication auth, RequestMap query)
        throws ApiException {

        Retrievals val = new Retrievals();
        if (query != null)  val.putAll(query);
        return new Retrievals(BaseObject.executeOperation(auth, "a5c0a117-4fba-426d-8e91-e0c2b0967b52", val));
    }
  /**
   * Creates a <code>Retrievals</code> object
   *
   * @param map a map of parameters to create a <code>Retrievals</code> object
   *
   * @return a Retrievals object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Retrievals issuerRespondToFulfillment(RequestMap map)
    throws ApiException {

    return issuerRespondToFulfillment(null, map);
  }

  /**
   * Creates a <code>Retrievals</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Retrievals</code> object
   *
   * @return a Retrievals object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Retrievals issuerRespondToFulfillment(Authentication auth, RequestMap map)
    throws ApiException {

    return new Retrievals(BaseObject.executeOperation(auth, "fa003814-6275-4aae-97a4-61c203933fe8", new Retrievals(map)));
  }







    /**
     * Update a <code>Retrievals</code> object.
     *
     * @return a Retrievals object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Retrievals retrievalFullfilmentImageStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "06ca5c57-6e18-4743-9f13-da1ee6a954a6", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Retrievals</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Retrievals object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Retrievals retrievalFullfilmentImageStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "06ca5c57-6e18-4743-9f13-da1ee6a954a6", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>Retrievals</code> object.
     *
     * @return a Retrievals object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Retrievals retrievalFullfilmentStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "c1fcb452-f007-470d-b0c9-16f881033a1c", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>Retrievals</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a Retrievals object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public Retrievals retrievalFullfilmentStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "c1fcb452-f007-470d-b0c9-16f881033a1c", this);
        this.putAll(object);
        return this;
    }




}


