/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RetrievalsDebitMasterCardAndEuropeDualAcquirer extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("208f1afb-7059-48d3-853f-3c425f517c66", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/debitmc/{request-id}/fulfillments", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("bd58d091-2224-47d8-ad94-dc7f524d6e1c", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/debitmc", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("3a9a7102-9f9d-48b3-b553-4eaafd9983fb", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/debitmc/{request-id}/documents", Action.query, Arrays.asList("format"), Arrays.asList("")));
        operationConfigs.put("5af588f7-6979-443c-abfd-aa5fd28636af", new OperationConfig("/mastercom/v6/claims/{claim-id}/retrievalrequests/debitmc/{request-id}/fulfillments/response", Action.create, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("3e0e4bc8-c9e7-4b5f-bffa-d126fd78bd4c", new OperationConfig("/mastercom/v6/retrievalrequests/debitmc/imagestatus", Action.update, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("bcfaf94b-9a9e-4392-8964-229d55040f79", new OperationConfig("/mastercom/v6/retrievalrequests/debitmc/status", Action.update, Arrays.asList(""), Arrays.asList("")));
    }

    public RetrievalsDebitMasterCardAndEuropeDualAcquirer() {
    }

    public RetrievalsDebitMasterCardAndEuropeDualAcquirer(BaseObject o) {
        putAll(o);
    }

    public RetrievalsDebitMasterCardAndEuropeDualAcquirer(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

  /**
   * Creates a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param map a map of parameters to create a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static RetrievalsDebitMasterCardAndEuropeDualAcquirer acquirerFulfillARequest(RequestMap map)
    throws ApiException {

    return acquirerFulfillARequest(null, map);
  }

  /**
   * Creates a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static RetrievalsDebitMasterCardAndEuropeDualAcquirer acquirerFulfillARequest(Authentication auth, RequestMap map)
    throws ApiException {

    return new RetrievalsDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "208f1afb-7059-48d3-853f-3c425f517c66", new RetrievalsDebitMasterCardAndEuropeDualAcquirer(map)));
  }






  /**
   * Creates a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param map a map of parameters to create a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static RetrievalsDebitMasterCardAndEuropeDualAcquirer create(RequestMap map)
    throws ApiException {

    return create(null, map);
  }

  /**
   * Creates a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static RetrievalsDebitMasterCardAndEuropeDualAcquirer create(Authentication auth, RequestMap map)
    throws ApiException {

    return new RetrievalsDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "bd58d091-2224-47d8-ad94-dc7f524d6e1c", new RetrievalsDebitMasterCardAndEuropeDualAcquirer(map)));
  }











    /**
     * Query / Retrieve a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
     *
     * @param query a map of query parameters
     *
     * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static RetrievalsDebitMasterCardAndEuropeDualAcquirer getDocumentation(RequestMap query)
        throws ApiException {

        return getDocumentation(null, query);
    }

    /**
     * Query / Retrieve a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param query a map of query parameters
     *
     * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static RetrievalsDebitMasterCardAndEuropeDualAcquirer getDocumentation(Authentication auth, RequestMap query)
        throws ApiException {

        RetrievalsDebitMasterCardAndEuropeDualAcquirer val = new RetrievalsDebitMasterCardAndEuropeDualAcquirer();
        if (query != null)  val.putAll(query);
        return new RetrievalsDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "3a9a7102-9f9d-48b3-b553-4eaafd9983fb", val));
    }
  /**
   * Creates a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param map a map of parameters to create a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static RetrievalsDebitMasterCardAndEuropeDualAcquirer issuerRespondToFulfillment(RequestMap map)
    throws ApiException {

    return issuerRespondToFulfillment(null, map);
  }

  /**
   * Creates a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object
   *
   * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static RetrievalsDebitMasterCardAndEuropeDualAcquirer issuerRespondToFulfillment(Authentication auth, RequestMap map)
    throws ApiException {

    return new RetrievalsDebitMasterCardAndEuropeDualAcquirer(BaseObject.executeOperation(auth, "5af588f7-6979-443c-abfd-aa5fd28636af", new RetrievalsDebitMasterCardAndEuropeDualAcquirer(map)));
  }







    /**
     * Update a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public RetrievalsDebitMasterCardAndEuropeDualAcquirer retrievalFullfilmentImageStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "3e0e4bc8-c9e7-4b5f-bffa-d126fd78bd4c", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public RetrievalsDebitMasterCardAndEuropeDualAcquirer retrievalFullfilmentImageStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "3e0e4bc8-c9e7-4b5f-bffa-d126fd78bd4c", this);
        this.putAll(object);
        return this;
    }





    /**
     * Update a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public RetrievalsDebitMasterCardAndEuropeDualAcquirer retrievalFullfilmentStatus()
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(null, "bcfaf94b-9a9e-4392-8964-229d55040f79", this);
        this.putAll(object);
        return this;
    }

    /**
     * Update a <code>RetrievalsDebitMasterCardAndEuropeDualAcquirer</code> object.
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     *
     * @return a RetrievalsDebitMasterCardAndEuropeDualAcquirer object.
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public RetrievalsDebitMasterCardAndEuropeDualAcquirer retrievalFullfilmentStatus(Authentication auth)
        throws ApiException {

        BaseObject object = BaseObject.executeOperation(auth, "bcfaf94b-9a9e-4392-8964-229d55040f79", this);
        this.putAll(object);
        return this;
    }




}


