/*
 * Copyright 2016 MasterCard International.
 *
 * Redistribution and use in source and binary forms, with or without modification, are 
 * permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of 
 * conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * Neither the name of the MasterCard International Incorporated nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 */

package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.*;
import com.mastercard.api.core.model.*;
import com.mastercard.api.core.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transactions extends BaseObject  {

    private static Map<String, OperationConfig> operationConfigs;

    static {
        operationConfigs = new HashMap<String, OperationConfig>();
        operationConfigs.put("d49706e7-23fe-4be2-a932-363550db8fc1", new OperationConfig("/mastercom/v6/claims/{claim-id}/transactions/clearing/{transaction-id}", Action.read, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("c14dbcf5-4208-406c-932a-bbb4d621f5e4", new OperationConfig("/mastercom/v6/claims/{claim-id}/transactions/authorization/{transaction-id}", Action.read, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("84c5673d-2b48-41af-b28d-6229c6b41686", new OperationConfig("/mastercom/v6/transactions/search", Action.create, Arrays.asList(""), Arrays.asList("")));
    }

    public Transactions() {
    }

    public Transactions(BaseObject o) {
        putAll(o);
    }

    public Transactions(RequestMap requestMap) {
        putAll(requestMap);
    }

    @Override protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException{
        OperationConfig operationConfig = operationConfigs.get(operationUUID);

        if(operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }

        return operationConfig;
    }

    @Override protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }





    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param id the id of the <code>Transactions</code> object to retrieve
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveClearingDetail(String id)
        throws ApiException {

        return retrieveClearingDetail(null, id, null);
    }

    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param id the id of the <code>Transactions</code> object to retrieve
     * @param map a map of additional parameters
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveClearingDetail(String id, RequestMap map)
        throws ApiException {

        return retrieveClearingDetail(null, id, map);
    }

    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param id the id of the <code>Transactions</code> object to retrieve
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveClearingDetail(Authentication auth, String id)
        throws ApiException {

        return retrieveClearingDetail(auth, id, null);
    }

    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param id the id of the <code>Transactions</code> object to retrieve
     * @param map a map of additional parameters
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveClearingDetail(Authentication auth, String id, RequestMap map)
        throws ApiException {

        Transactions val = new Transactions();
        if (id != null) val.put("id", id);
        if (map != null)  val.putAll(map);
        return new Transactions(BaseObject.executeOperation(auth, "d49706e7-23fe-4be2-a932-363550db8fc1", val));
    }





    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param id the id of the <code>Transactions</code> object to retrieve
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveAuthorizationDetail(String id)
        throws ApiException {

        return retrieveAuthorizationDetail(null, id, null);
    }

    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param id the id of the <code>Transactions</code> object to retrieve
     * @param map a map of additional parameters
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveAuthorizationDetail(String id, RequestMap map)
        throws ApiException {

        return retrieveAuthorizationDetail(null, id, map);
    }

    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param id the id of the <code>Transactions</code> object to retrieve
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveAuthorizationDetail(Authentication auth, String id)
        throws ApiException {

        return retrieveAuthorizationDetail(auth, id, null);
    }

    /**
     * Retrieve a <code>Transactions</code> object
     *
     * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
     * @param id the id of the <code>Transactions</code> object to retrieve
     * @param map a map of additional parameters
     *
     * @return a Transactions object
     *
     * @throws ApiException - which encapsulates the http status code and the error return by the server
     */
    public static Transactions retrieveAuthorizationDetail(Authentication auth, String id, RequestMap map)
        throws ApiException {

        Transactions val = new Transactions();
        if (id != null) val.put("id", id);
        if (map != null)  val.putAll(map);
        return new Transactions(BaseObject.executeOperation(auth, "c14dbcf5-4208-406c-932a-bbb4d621f5e4", val));
    }

  /**
   * Creates a <code>Transactions</code> object
   *
   * @param map a map of parameters to create a <code>Transactions</code> object
   *
   * @return a Transactions object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Transactions searchForTransaction(RequestMap map)
    throws ApiException {

    return searchForTransaction(null, map);
  }

  /**
   * Creates a <code>Transactions</code> object
   *
   * @param auth Authentication object overriding <code>ApiConfig.setAuthentication(authentication)</code>
   * @param map a map of parameters to create a <code>Transactions</code> object
   *
   * @return a Transactions object.
   *
   * @throws ApiException - which encapsulates the http status code and the error return by the server
   */
  public static Transactions searchForTransaction(Authentication auth, RequestMap map)
    throws ApiException {

    return new Transactions(BaseObject.executeOperation(auth, "84c5673d-2b48-41af-b28d-6229c6b41686", new Transactions(map)));
  }






}


