/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.api.mdescustomerservice;

import com.mastercard.api.core.ApiConfig;
import com.mastercard.api.core.model.Environment;
import com.mastercard.api.core.model.ResourceConfigInterface;

public class ResourceConfig
implements ResourceConfigInterface {
    private String override = null;
    private String host = null;
    private String context = null;
    private static ResourceConfig instance = null;

    private ResourceConfig() {
    }

    public static ResourceConfig getInstance() {
        if (instance == null) {
            instance = new ResourceConfig();
            instance.setEnvironment(ApiConfig.getEnvironment());
            ApiConfig.registerResourceConfig((ResourceConfigInterface)instance);
        }
        return instance;
    }

    public String getContext() {
        return this.context;
    }

    public String getHost() {
        return this.override != null ? this.override : this.host;
    }

    public String getVersion() {
        return "1.0.6";
    }

    public boolean getJsonNative() {
        return false;
    }

    public void setEnvironment(Environment environment) {
        if (!Environment.MAPPINGS.containsKey(environment)) {
            throw new RuntimeException("Environment: " + environment.name() + " not found for sdk:" + this.getClass().getName());
        }
        String[] config = (String[])Environment.MAPPINGS.get(environment);
        this.host = config[0];
        this.context = config[1];
    }

    public void setEnvironment(String host, String context) {
        this.context = context;
        this.host = host;
    }
}

