/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.api.p2m;

import com.mastercard.api.core.exception.ApiException;
import com.mastercard.api.core.model.Action;
import com.mastercard.api.core.model.BaseObject;
import com.mastercard.api.core.model.OperationConfig;
import com.mastercard.api.core.model.OperationMetadata;
import com.mastercard.api.core.model.RequestMap;
import com.mastercard.api.core.security.Authentication;
import com.mastercard.api.p2m.ResourceConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MerchantRetrieval
extends BaseObject {
    private static Map<String, OperationConfig> operationConfigs = new HashMap<String, OperationConfig>();

    public MerchantRetrieval() {
    }

    public MerchantRetrieval(BaseObject o) {
        this.putAll((Map)o);
    }

    public MerchantRetrieval(RequestMap requestMap) {
        this.putAll((Map)requestMap);
    }

    protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException {
        OperationConfig operationConfig = operationConfigs.get(operationUUID);
        if (operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }
        return operationConfig;
    }

    protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

    public static MerchantRetrieval readByID(String id) throws ApiException {
        return MerchantRetrieval.readByID(null, id, null);
    }

    public static MerchantRetrieval readByID(String id, RequestMap map) throws ApiException {
        return MerchantRetrieval.readByID(null, id, map);
    }

    public static MerchantRetrieval readByID(Authentication auth, String id) throws ApiException {
        return MerchantRetrieval.readByID(auth, id, null);
    }

    public static MerchantRetrieval readByID(Authentication auth, String id, RequestMap map) throws ApiException {
        MerchantRetrieval val = new MerchantRetrieval();
        if (id != null) {
            val.put("id", id);
        }
        if (map != null) {
            val.putAll((Map)map);
        }
        return new MerchantRetrieval(BaseObject.executeOperation((Authentication)auth, (String)"d5b609bd-db39-4216-a04c-773c20b833dd", (BaseObject)val));
    }

    public static MerchantRetrieval readByReference(RequestMap query) throws ApiException {
        return MerchantRetrieval.readByReference(null, query);
    }

    public static MerchantRetrieval readByReference(Authentication auth, RequestMap query) throws ApiException {
        MerchantRetrieval val = new MerchantRetrieval();
        if (query != null) {
            val.putAll((Map)query);
        }
        return new MerchantRetrieval(BaseObject.executeOperation((Authentication)auth, (String)"106e037a-08c9-4187-a61c-694d029936d9", (BaseObject)val));
    }

    static {
        operationConfigs.put("d5b609bd-db39-4216-a04c-773c20b833dd", new OperationConfig("/send/#env/v1/partners/{partnerId}/merchant/transfers/{transferId}", Action.read, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("106e037a-08c9-4187-a61c-694d029936d9", new OperationConfig("/send/#env/v1/partners/{partnerId}/merchant/transfers", Action.query, Arrays.asList("ref"), Arrays.asList("")));
    }
}

