/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.json.JsonEngine;
import com.mastercard.developer.utils.EncodingUtils;
import com.mastercard.developer.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;

public class FieldLevelEncryption {
    private static final String SYMMETRIC_CYPHER = "AES/CBC/PKCS5Padding";
    private static JsonEngine jsonEngine;
    private static Configuration jsonPathConfig;

    private FieldLevelEncryption() {
    }

    public static synchronized Configuration withJsonEngine(JsonEngine jsonEngine) {
        FieldLevelEncryption.jsonEngine = jsonEngine;
        jsonPathConfig = new Configuration.ConfigurationBuilder().jsonProvider(jsonEngine.getJsonProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
        return jsonPathConfig;
    }

    public static String encryptPayload(String payload, FieldLevelEncryptionConfig config) throws EncryptionException {
        return FieldLevelEncryption.encryptPayload(payload, config, null);
    }

    public static String encryptPayload(String payload, FieldLevelEncryptionConfig config, FieldLevelEncryptionParams params) throws EncryptionException {
        try {
            DocumentContext payloadContext = JsonPath.parse((String)payload, (Configuration)jsonPathConfig);
            for (Map.Entry<String, String> entry : config.encryptionPaths.entrySet()) {
                String jsonPathIn = entry.getKey();
                String jsonPathOut = entry.getValue();
                FieldLevelEncryption.encryptPayloadPath(payloadContext, jsonPathIn, jsonPathOut, config, params);
            }
            return payloadContext.jsonString();
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Payload encryption failed!", e);
        }
    }

    public static String decryptPayload(String payload, FieldLevelEncryptionConfig config) throws EncryptionException {
        return FieldLevelEncryption.decryptPayload(payload, config, null);
    }

    public static String decryptPayload(String payload, FieldLevelEncryptionConfig config, FieldLevelEncryptionParams params) throws EncryptionException {
        try {
            DocumentContext payloadContext = JsonPath.parse((String)payload, (Configuration)jsonPathConfig);
            for (Map.Entry<String, String> entry : config.decryptionPaths.entrySet()) {
                String jsonPathIn = entry.getKey();
                String jsonPathOut = entry.getValue();
                FieldLevelEncryption.decryptPayloadPath(payloadContext, jsonPathIn, jsonPathOut, config, params);
            }
            return payloadContext.jsonString();
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Payload decryption failed!", e);
        }
    }

    private static void encryptPayloadPath(DocumentContext payloadContext, String jsonPathIn, String jsonPathOut, FieldLevelEncryptionConfig config, FieldLevelEncryptionParams params) throws GeneralSecurityException, EncryptionException {
        Object inJsonElement = FieldLevelEncryption.readJsonElement(payloadContext, jsonPathIn);
        if (inJsonElement == null) {
            return;
        }
        if (params == null) {
            params = FieldLevelEncryptionParams.generate(config);
        }
        String inJsonString = FieldLevelEncryption.sanitizeJson(jsonEngine.toJsonString(inJsonElement));
        byte[] inJsonBytes = null;
        try {
            inJsonBytes = inJsonString.getBytes(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] encryptedValueBytes = FieldLevelEncryption.encryptBytes(params.getSecretKey(), params.getIvSpec(), inJsonBytes);
        String encryptedValue = EncodingUtils.encodeBytes(encryptedValueBytes, config.fieldValueEncoding);
        if (!"$".equals(jsonPathIn)) {
            payloadContext.delete(jsonPathIn, new Predicate[0]);
        } else {
            ArrayList<String> propertyKeys = new ArrayList<String>(jsonEngine.getPropertyKeys(inJsonElement));
            for (String key : propertyKeys) {
                payloadContext.delete(jsonPathIn + "." + key, new Predicate[0]);
            }
        }
        FieldLevelEncryption.checkOrCreateOutObject(payloadContext, jsonPathOut);
        payloadContext.put(jsonPathOut, config.encryptedValueFieldName, (Object)encryptedValue, new Predicate[0]);
        if (!StringUtils.isNullOrEmpty(config.ivFieldName)) {
            payloadContext.put(jsonPathOut, config.ivFieldName, (Object)params.getIvValue(), new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.encryptedKeyFieldName)) {
            payloadContext.put(jsonPathOut, config.encryptedKeyFieldName, (Object)params.getEncryptedKeyValue(), new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.encryptionCertificateFingerprintFieldName)) {
            payloadContext.put(jsonPathOut, config.encryptionCertificateFingerprintFieldName, (Object)config.encryptionCertificateFingerprint, new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.encryptionKeyFingerprintFieldName)) {
            payloadContext.put(jsonPathOut, config.encryptionKeyFingerprintFieldName, (Object)config.encryptionKeyFingerprint, new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.oaepPaddingDigestAlgorithmFieldName)) {
            payloadContext.put(jsonPathOut, config.oaepPaddingDigestAlgorithmFieldName, (Object)params.getOaepPaddingDigestAlgorithmValue(), new Predicate[0]);
        }
    }

    private static void decryptPayloadPath(DocumentContext payloadContext, String jsonPathIn, String jsonPathOut, FieldLevelEncryptionConfig config, FieldLevelEncryptionParams params) throws GeneralSecurityException, EncryptionException {
        JsonProvider jsonProvider = jsonPathConfig.jsonProvider();
        Object inJsonObject = FieldLevelEncryption.readJsonObject(payloadContext, jsonPathIn);
        if (inJsonObject == null) {
            return;
        }
        Object encryptedValueJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptedValueFieldName);
        if (jsonEngine.isNullOrEmptyJson(encryptedValueJsonElement)) {
            return;
        }
        if (!config.useHttpPayloads() && params == null) {
            throw new IllegalStateException("Encryption params have to be set when not stored in HTTP payloads!");
        }
        if (params == null) {
            Object oaepDigestAlgorithmJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.oaepPaddingDigestAlgorithmFieldName);
            String oaepDigestAlgorithm = jsonEngine.isNullOrEmptyJson(oaepDigestAlgorithmJsonElement) ? config.oaepPaddingDigestAlgorithm : jsonEngine.toJsonString(oaepDigestAlgorithmJsonElement);
            Object encryptedKeyJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptedKeyFieldName);
            Object ivJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.ivFieldName);
            FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptionCertificateFingerprintFieldName);
            FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptionKeyFingerprintFieldName);
            params = new FieldLevelEncryptionParams(jsonEngine.toJsonString(ivJsonElement), jsonEngine.toJsonString(encryptedKeyJsonElement), oaepDigestAlgorithm, config);
        }
        byte[] encryptedValueBytes = EncodingUtils.decodeValue(jsonEngine.toJsonString(encryptedValueJsonElement), config.fieldValueEncoding);
        byte[] decryptedValueBytes = FieldLevelEncryption.decryptBytes(params.getSecretKey(), params.getIvSpec(), encryptedValueBytes);
        String decryptedValue = new String(decryptedValueBytes, StandardCharsets.UTF_8);
        decryptedValue = FieldLevelEncryption.sanitizeJson(decryptedValue);
        FieldLevelEncryption.checkOrCreateOutObject(payloadContext, jsonPathOut);
        FieldLevelEncryption.addDecryptedDataToPayload(payloadContext, decryptedValue, jsonPathOut);
        Object inJsonElement = FieldLevelEncryption.readJsonElement(payloadContext, jsonPathIn);
        if (0 == jsonProvider.length(inJsonElement) && !"$".equals(jsonPathIn)) {
            payloadContext.delete(jsonPathIn, new Predicate[0]);
        }
    }

    private static void addDecryptedDataToPayload(DocumentContext payloadContext, String decryptedValue, String jsonPathOut) {
        JsonProvider jsonProvider = jsonPathConfig.jsonProvider();
        Object decryptedValueJsonElement = jsonEngine.parse(decryptedValue);
        if (!jsonEngine.isJsonObject(decryptedValueJsonElement)) {
            payloadContext.set(jsonPathOut, decryptedValueJsonElement, new Predicate[0]);
            return;
        }
        int length = jsonProvider.length(decryptedValueJsonElement);
        List<String> propertyKeys = 0 == length ? Collections.emptyList() : jsonProvider.getPropertyKeys(decryptedValueJsonElement);
        for (String key : propertyKeys) {
            payloadContext.delete(jsonPathOut + "." + key, new Predicate[0]);
            payloadContext.put(jsonPathOut, key, jsonProvider.getMapValue(decryptedValueJsonElement, key), new Predicate[0]);
        }
    }

    private static void checkOrCreateOutObject(DocumentContext context, String jsonPathOutString) {
        Object outJsonObject = FieldLevelEncryption.readJsonObject(context, jsonPathOutString);
        if (null != outJsonObject) {
            return;
        }
        String parentJsonPath = JsonEngine.getParentJsonPath(jsonPathOutString);
        Object parentJsonObject = FieldLevelEncryption.readJsonObject(context, parentJsonPath);
        if (parentJsonObject == null) {
            throw new IllegalArgumentException(String.format("Parent path not found in payload: '%s'!", parentJsonPath));
        }
        outJsonObject = jsonPathConfig.jsonProvider().createMap();
        String elementKey = JsonEngine.getJsonElementKey(jsonPathOutString);
        context.put(parentJsonPath, elementKey, outJsonObject, new Predicate[0]);
    }

    private static Object readJsonElement(DocumentContext context, String jsonPathString) {
        Object payloadJsonObject = context.json();
        JsonPath jsonPath = JsonPath.compile((String)jsonPathString, (Predicate[])new Predicate[0]);
        return jsonPath.read(payloadJsonObject, jsonPathConfig);
    }

    private static Object readJsonObject(DocumentContext context, String jsonPathString) {
        Object jsonElement = FieldLevelEncryption.readJsonElement(context, jsonPathString);
        if (jsonElement == null) {
            return null;
        }
        if (!jsonEngine.isJsonObject(jsonElement)) {
            throw new IllegalArgumentException(String.format("JSON object expected at path: '%s'!", jsonPathString));
        }
        return jsonElement;
    }

    private static Object readAndDeleteJsonKey(DocumentContext context, String objectPath, Object object, String key) {
        if (null == key) {
            return null;
        }
        JsonProvider jsonProvider = jsonPathConfig.jsonProvider();
        Object value = jsonProvider.getMapValue(object, key);
        context.delete(objectPath + "." + key, new Predicate[0]);
        return value;
    }

    private static String sanitizeJson(String json) {
        return json.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
    }

    protected static byte[] encryptBytes(Key key, AlgorithmParameterSpec iv, byte[] bytes) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(SYMMETRIC_CYPHER);
        cipher.init(1, key, iv);
        return cipher.doFinal(bytes);
    }

    protected static byte[] decryptBytes(Key key, AlgorithmParameterSpec iv, byte[] bytes) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(SYMMETRIC_CYPHER);
        cipher.init(2, key, iv);
        return cipher.doFinal(bytes);
    }

    static {
        jsonPathConfig = FieldLevelEncryption.withJsonEngine(JsonEngine.getDefault());
    }
}

