/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;

public class FieldLevelEncryptionConfig {
    protected Certificate encryptionCertificate;
    protected String encryptionCertificateFingerprint;
    protected String encryptionKeyFingerprint;
    protected PrivateKey decryptionKey;
    protected Map<String, String> encryptionPaths = Collections.emptyMap();
    protected Map<String, String> decryptionPaths = Collections.emptyMap();
    protected String oaepPaddingDigestAlgorithm = null;
    protected String oaepPaddingDigestAlgorithmFieldName = null;
    protected String oaepPaddingDigestAlgorithmHeaderName = null;
    protected String ivFieldName = null;
    protected String ivHeaderName = null;
    protected String encryptedKeyFieldName = null;
    protected String encryptedKeyHeaderName = null;
    protected String encryptedValueFieldName = null;
    protected String encryptionCertificateFingerprintFieldName = null;
    protected String encryptionCertificateFingerprintHeaderName = null;
    protected String encryptionKeyFingerprintFieldName = null;
    protected String encryptionKeyFingerprintHeaderName = null;
    protected FieldValueEncoding fieldValueEncoding;

    protected FieldLevelEncryptionConfig() {
    }

    public boolean useHttpHeaders() {
        return this.encryptedKeyHeaderName != null && this.ivHeaderName != null;
    }

    public boolean useHttpPayloads() {
        return this.encryptedKeyFieldName != null && this.ivFieldName != null;
    }

    public String getOaepPaddingDigestAlgorithmHeaderName() {
        return this.oaepPaddingDigestAlgorithmHeaderName;
    }

    public String getIvHeaderName() {
        return this.ivHeaderName;
    }

    public String getEncryptedKeyHeaderName() {
        return this.encryptedKeyHeaderName;
    }

    public String getEncryptionCertificateFingerprintHeaderName() {
        return this.encryptionCertificateFingerprintHeaderName;
    }

    public String getEncryptionKeyFingerprintHeaderName() {
        return this.encryptionKeyFingerprintHeaderName;
    }

    public String getEncryptionCertificateFingerprint() {
        return this.encryptionCertificateFingerprint;
    }

    public String getEncryptionKeyFingerprint() {
        return this.encryptionKeyFingerprint;
    }

    public static enum FieldValueEncoding {
        BASE64,
        HEX;

    }
}

