/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.utils.EncodingUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class FieldLevelEncryptionParams {
    private static final Integer SYMMETRIC_KEY_SIZE = 128;
    protected static final String SYMMETRIC_KEY_TYPE = "AES";
    private static final String ASYMMETRIC_CYPHER = "RSA/ECB/OAEPWith{ALG}AndMGF1Padding";
    private final String ivValue;
    private final String encryptedKeyValue;
    private final String oaepPaddingDigestAlgorithmValue;
    private final FieldLevelEncryptionConfig config;
    private Key secretKey;
    private IvParameterSpec ivParameterSpec;

    public FieldLevelEncryptionParams(String ivValue, String encryptedKeyValue, String oaepPaddingDigestAlgorithmValue, FieldLevelEncryptionConfig config) {
        this.ivValue = ivValue;
        this.encryptedKeyValue = encryptedKeyValue;
        this.oaepPaddingDigestAlgorithmValue = oaepPaddingDigestAlgorithmValue;
        this.config = config;
    }

    public static FieldLevelEncryptionParams generate(FieldLevelEncryptionConfig config) throws EncryptionException {
        IvParameterSpec ivParameterSpec = FieldLevelEncryptionParams.generateIv();
        String ivSpecValue = EncodingUtils.encodeBytes(ivParameterSpec.getIV(), config.fieldValueEncoding);
        SecretKey secretKey = FieldLevelEncryptionParams.generateSecretKey();
        byte[] encryptedSecretKeyBytes = FieldLevelEncryptionParams.wrapSecretKey(config, secretKey);
        String encryptedKeyValue = EncodingUtils.encodeBytes(encryptedSecretKeyBytes, config.fieldValueEncoding);
        String oaepPaddingDigestAlgorithmValue = config.oaepPaddingDigestAlgorithm.replace("-", "");
        FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivSpecValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, config);
        params.secretKey = secretKey;
        params.ivParameterSpec = ivParameterSpec;
        return params;
    }

    public String getIvValue() {
        return this.ivValue;
    }

    public String getEncryptedKeyValue() {
        return this.encryptedKeyValue;
    }

    public String getOaepPaddingDigestAlgorithmValue() {
        return this.oaepPaddingDigestAlgorithmValue;
    }

    public Key getSecretKey() throws EncryptionException {
        try {
            if (this.secretKey != null) {
                return this.secretKey;
            }
            byte[] encryptedSecretKeyBytes = EncodingUtils.decodeValue(this.encryptedKeyValue, this.config.fieldValueEncoding);
            this.secretKey = FieldLevelEncryptionParams.unwrapSecretKey(this.config, encryptedSecretKeyBytes, this.oaepPaddingDigestAlgorithmValue);
            return this.secretKey;
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to decode and unwrap the provided secret key value!", e);
        }
    }

    public IvParameterSpec getIvSpec() throws EncryptionException {
        try {
            if (this.ivParameterSpec != null) {
                return this.ivParameterSpec;
            }
            byte[] ivByteArray = EncodingUtils.decodeValue(this.ivValue, this.config.fieldValueEncoding);
            this.ivParameterSpec = new IvParameterSpec(ivByteArray);
            return this.ivParameterSpec;
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to decode the provided IV value!", e);
        }
    }

    private static IvParameterSpec generateIv() throws EncryptionException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] ivBytes = new byte[16];
            secureRandom.nextBytes(ivBytes);
            return new IvParameterSpec(ivBytes);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Failed to generate an IV value!", e);
        }
    }

    private static SecretKey generateSecretKey() throws EncryptionException {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(SYMMETRIC_KEY_TYPE);
            generator.init(SYMMETRIC_KEY_SIZE);
            return generator.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Failed to generate a secret key!", e);
        }
    }

    protected static byte[] wrapSecretKey(FieldLevelEncryptionConfig config, Key key) throws EncryptionException {
        try {
            PublicKey publicEncryptionKey = config.encryptionCertificate.getPublicKey();
            MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec(config.oaepPaddingDigestAlgorithm);
            String asymmetricCipher = ASYMMETRIC_CYPHER.replace("{ALG}", mgf1ParameterSpec.getDigestAlgorithm());
            Cipher cipher = Cipher.getInstance(asymmetricCipher);
            cipher.init(3, (Key)publicEncryptionKey, FieldLevelEncryptionParams.getOaepParameterSpec(mgf1ParameterSpec));
            return cipher.wrap(key);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Failed to wrap secret key!", e);
        }
    }

    protected static Key unwrapSecretKey(FieldLevelEncryptionConfig config, byte[] keyBytes, String oaepDigestAlgorithm) throws EncryptionException {
        if (!oaepDigestAlgorithm.contains("-")) {
            oaepDigestAlgorithm = oaepDigestAlgorithm.replace("SHA", "SHA-");
        }
        try {
            MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec(oaepDigestAlgorithm);
            PrivateKey key = config.decryptionKey;
            String asymmetricCipher = ASYMMETRIC_CYPHER.replace("{ALG}", mgf1ParameterSpec.getDigestAlgorithm());
            Cipher cipher = Cipher.getInstance(asymmetricCipher);
            cipher.init(4, (Key)key, FieldLevelEncryptionParams.getOaepParameterSpec(mgf1ParameterSpec));
            return cipher.unwrap(keyBytes, SYMMETRIC_KEY_TYPE, 3);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Failed to unwrap secret key!", e);
        }
    }

    private static OAEPParameterSpec getOaepParameterSpec(MGF1ParameterSpec mgf1ParameterSpec) {
        return new OAEPParameterSpec(mgf1ParameterSpec.getDigestAlgorithm(), "MGF1", mgf1ParameterSpec, PSource.PSpecified.DEFAULT);
    }
}

