/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;

public class HttpExecuteFieldLevelEncryptionInterceptor
implements HttpExecuteInterceptor,
HttpResponseInterceptor {
    private final FieldLevelEncryptionConfig config;

    public HttpExecuteFieldLevelEncryptionInterceptor(FieldLevelEncryptionConfig config) {
        this.config = config;
    }

    public void intercept(HttpRequest request) throws IOException {
        try {
            String encryptedPayload;
            HttpContent content = request.getContent();
            if (null == content || content.getLength() == 0L) {
                return;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)outputStream);
            String requestPayload = outputStream.toString(StandardCharsets.UTF_8.name());
            HttpHeaders headers = request.getHeaders();
            if (this.config.useHttpHeaders()) {
                FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(this.config);
                HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getIvHeaderName(), params.getIvValue());
                HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
                HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getEncryptionCertificateFingerprintHeaderName(), this.config.getEncryptionCertificateFingerprint());
                HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getEncryptionKeyFingerprintHeaderName(), this.config.getEncryptionKeyFingerprint());
                HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
                encryptedPayload = FieldLevelEncryption.encryptPayload(requestPayload, this.config, params);
            } else {
                encryptedPayload = FieldLevelEncryption.encryptPayload(requestPayload, this.config);
            }
            ByteArrayContent encryptedContent = new ByteArrayContent("application/json; charset=" + StandardCharsets.UTF_8.name(), encryptedPayload.getBytes());
            headers.setContentLength(Long.valueOf(encryptedContent.getLength()));
            request.setContent((HttpContent)encryptedContent);
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and encrypt request!", e);
        }
    }

    public void interceptResponse(HttpResponse response) throws IOException {
        try {
            String decryptedPayload;
            String responsePayload = response.parseAsString();
            if (StringUtils.isNullOrEmpty(responsePayload)) {
                return;
            }
            HttpHeaders headers = response.getHeaders();
            if (this.config.useHttpHeaders()) {
                String ivValue = headers.getFirstHeaderStringValue(this.config.getIvHeaderName());
                String oaepPaddingDigestAlgorithmValue = headers.getFirstHeaderStringValue(this.config.getOaepPaddingDigestAlgorithmHeaderName());
                String encryptedKeyValue = headers.getFirstHeaderStringValue(this.config.getEncryptedKeyHeaderName());
                HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getIvHeaderName());
                HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getEncryptedKeyHeaderName());
                HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getOaepPaddingDigestAlgorithmHeaderName());
                HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getEncryptionCertificateFingerprintHeaderName());
                HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getEncryptionKeyFingerprintHeaderName());
                FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, this.config);
                decryptedPayload = FieldLevelEncryption.decryptPayload(responsePayload, this.config, params);
            } else {
                decryptedPayload = FieldLevelEncryption.decryptPayload(responsePayload, this.config);
            }
            ByteArrayContent decryptedContent = new ByteArrayContent("application/json; charset=" + StandardCharsets.UTF_8.name(), decryptedPayload.getBytes());
            headers.setContentLength(Long.valueOf(decryptedContent.getLength()));
            Field contentField = response.getClass().getDeclaredField("content");
            contentField.setAccessible(true);
            contentField.set(response, decryptedContent.getInputStream());
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and decrypt response!", e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException("Failed to update response with decrypted payload!", e);
        }
    }

    private static void removeHeader(HttpHeaders headers, String name) {
        if (name == null) {
            return;
        }
        headers.remove((Object)name);
    }

    private static void updateHeader(HttpHeaders headers, String name, String value) {
        if (name == null) {
            return;
        }
        headers.remove((Object)name);
        headers.set(name, (Object)value);
    }
}

