/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.utils.StringUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class OkHttpFieldLevelEncryptionInterceptor
implements Interceptor {
    private final FieldLevelEncryptionConfig config;

    public OkHttpFieldLevelEncryptionInterceptor(FieldLevelEncryptionConfig config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request encryptedRequest = OkHttpFieldLevelEncryptionInterceptor.handleRequest(chain.request(), this.config);
        Response encryptedResponse = chain.proceed(encryptedRequest);
        return OkHttpFieldLevelEncryptionInterceptor.handleResponse(encryptedResponse, this.config);
    }

    private static Request handleRequest(Request request, FieldLevelEncryptionConfig config) throws IOException {
        try {
            String encryptedPayload;
            String requestPayload;
            RequestBody requestBody = request.body();
            if (null == requestBody || requestBody.contentLength() == 0L) {
                return request;
            }
            try (Buffer buffer = new Buffer();){
                request.body().writeTo((BufferedSink)buffer);
                requestPayload = buffer.readUtf8();
            }
            Request.Builder requestBuilder = request.newBuilder();
            if (config.useHttpHeaders()) {
                FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(config);
                OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, config.getIvHeaderName(), params.getIvValue());
                OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
                OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, config.getEncryptionCertificateFingerprintHeaderName(), config.getEncryptionCertificateFingerprint());
                OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, config.getEncryptionKeyFingerprintHeaderName(), config.getEncryptionKeyFingerprint());
                OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
                encryptedPayload = FieldLevelEncryption.encryptPayload(requestPayload, config, params);
            } else {
                encryptedPayload = FieldLevelEncryption.encryptPayload(requestPayload, config);
            }
            RequestBody encryptedBody = RequestBody.create((MediaType)requestBody.contentType(), (String)encryptedPayload);
            return requestBuilder.method(request.method(), encryptedBody).header("Content-Length", String.valueOf(encryptedBody.contentLength())).build();
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and encrypt request!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Response handleResponse(Response response, FieldLevelEncryptionConfig config) throws IOException {
        try {
            String decryptedPayload;
            ResponseBody responseBody = response.body();
            if (null == responseBody) {
                return response;
            }
            String responsePayload = responseBody.string();
            if (StringUtils.isNullOrEmpty(responsePayload)) {
                return response;
            }
            Response.Builder responseBuilder = response.newBuilder();
            if (config.useHttpHeaders()) {
                String ivValue = response.header(config.getIvHeaderName(), null);
                String oaepPaddingDigestAlgorithmValue = response.header(config.getOaepPaddingDigestAlgorithmHeaderName(), null);
                String encryptedKeyValue = response.header(config.getEncryptedKeyHeaderName(), null);
                OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, config.getIvHeaderName());
                OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, config.getEncryptedKeyHeaderName());
                OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, config.getOaepPaddingDigestAlgorithmHeaderName());
                OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, config.getEncryptionCertificateFingerprintHeaderName());
                OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, config.getEncryptionKeyFingerprintHeaderName());
                FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, config);
                decryptedPayload = FieldLevelEncryption.decryptPayload(responsePayload, config, params);
            } else {
                decryptedPayload = FieldLevelEncryption.decryptPayload(responsePayload, config);
            }
            try (ResponseBody decryptedBody = ResponseBody.create((MediaType)responseBody.contentType(), (String)decryptedPayload);){
                Response response2 = responseBuilder.body(decryptedBody).header("Content-Length", String.valueOf(decryptedBody.contentLength())).build();
                return response2;
            }
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and decrypt response!", e);
        }
    }

    private static void removeHeader(Response.Builder responseBuilder, String name) {
        if (name == null) {
            return;
        }
        responseBuilder.removeHeader(name);
    }

    private static void updateHeader(Request.Builder requestBuilder, String name, String value) {
        if (name == null) {
            return;
        }
        requestBuilder.header(name, value);
    }
}

