/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.utils.FeignUtils;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class OpenFeignFieldLevelEncryptionEncoder
implements Encoder {
    private final FieldLevelEncryptionConfig config;
    private final Encoder delegate;

    public OpenFeignFieldLevelEncryptionEncoder(FieldLevelEncryptionConfig config, Encoder delegate) {
        this.config = config;
        this.delegate = delegate;
    }

    public void encode(Object object, Type type, RequestTemplate requestTemplate) {
        this.delegate.encode(object, type, requestTemplate);
        try {
            String encryptedPayload;
            byte[] bodyBytes = requestTemplate.body();
            if (null == bodyBytes || bodyBytes.length <= 0) {
                return;
            }
            String payload = new String(bodyBytes, StandardCharsets.UTF_8);
            if (this.config.useHttpHeaders()) {
                FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(this.config);
                FeignUtils.updateHeader(requestTemplate, this.config.getIvHeaderName(), params.getIvValue());
                FeignUtils.updateHeader(requestTemplate, this.config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
                FeignUtils.updateHeader(requestTemplate, this.config.getEncryptionCertificateFingerprintHeaderName(), this.config.getEncryptionCertificateFingerprint());
                FeignUtils.updateHeader(requestTemplate, this.config.getEncryptionKeyFingerprintHeaderName(), this.config.getEncryptionKeyFingerprint());
                FeignUtils.updateHeader(requestTemplate, this.config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
                encryptedPayload = FieldLevelEncryption.encryptPayload(payload, this.config, params);
            } else {
                encryptedPayload = FieldLevelEncryption.encryptPayload(payload, this.config);
            }
            requestTemplate.body(encryptedPayload);
            FeignUtils.updateHeader(requestTemplate, "Content-Length", String.valueOf(encryptedPayload.length()));
        }
        catch (EncryptionException e) {
            throw new EncodeException("Failed to intercept and encrypt request!", (Throwable)e);
        }
    }
}

