/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.utils;

import feign.RequestTemplate;
import feign.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FeignUtils {
    private FeignUtils() {
    }

    public static void updateHeader(RequestTemplate request, String name, String value) {
        if (name == null) {
            return;
        }
        Map headers = request.headers();
        HashSet headerNames = new HashSet(headers.keySet());
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            request.header(name, new String[]{null});
        }
        if (value != null) {
            request.header(name, new String[]{value});
        }
    }

    public static Response updateHeader(Response response, String name, String value) {
        if (name == null) {
            return response;
        }
        HashMap<String, Set<String>> headers = new HashMap<String, Set<String>>(response.headers());
        HashSet headerNames = new HashSet(headers.keySet());
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            headers.remove(headerName);
        }
        if (value != null) {
            headers.put(name, Collections.singleton(value));
        }
        return response.toBuilder().headers(headers).build();
    }

    public static String readHeader(Response response, String name) {
        if (name == null) {
            return null;
        }
        Map headers = response.headers();
        Set headerNames = headers.keySet();
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return (String)((Collection)headers.get(headerName)).toArray()[0];
        }
        return null;
    }

    public static Response removeHeader(Response response, String name) {
        return FeignUtils.updateHeader(response, name, null);
    }
}

