/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.JsonPath;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.utils.EncodingUtils;
import com.mastercard.developer.utils.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.util.HashMap;
import java.util.Map;

public final class FieldLevelEncryptionConfigBuilder {
    private Certificate encryptionCertificate;
    private String encryptionCertificateFingerprint;
    private String encryptionKeyFingerprint;
    private PrivateKey decryptionKey;
    private Map<String, String> encryptionPaths = new HashMap<String, String>();
    private Map<String, String> decryptionPaths = new HashMap<String, String>();
    private String oaepPaddingDigestAlgorithm;
    private String ivFieldName;
    private String ivHeaderName;
    private String oaepPaddingDigestAlgorithmFieldName;
    private String oaepPaddingDigestAlgorithmHeaderName;
    private String encryptedKeyFieldName;
    private String encryptedKeyHeaderName;
    private String encryptedValueFieldName;
    private String encryptionCertificateFingerprintFieldName;
    private String encryptionCertificateFingerprintHeaderName;
    private String encryptionKeyFingerprintFieldName;
    private String encryptionKeyFingerprintHeaderName;
    private FieldLevelEncryptionConfig.FieldValueEncoding fieldValueEncoding;

    private FieldLevelEncryptionConfigBuilder() {
    }

    public static FieldLevelEncryptionConfigBuilder aFieldLevelEncryptionConfig() {
        return new FieldLevelEncryptionConfigBuilder();
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionCertificate(Certificate encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionCertificateFingerprint(String encryptionCertificateFingerprint) {
        this.encryptionCertificateFingerprint = encryptionCertificateFingerprint;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionKeyFingerprint(String encryptionKeyFingerprint) {
        this.encryptionKeyFingerprint = encryptionKeyFingerprint;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withDecryptionKey(PrivateKey decryptionKey) {
        this.decryptionKey = decryptionKey;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionPath(String jsonPathIn, String jsonPathOut) {
        this.encryptionPaths.put(jsonPathIn, jsonPathOut);
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withDecryptionPath(String jsonPathIn, String jsonPathOut) {
        this.decryptionPaths.put(jsonPathIn, jsonPathOut);
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withOaepPaddingDigestAlgorithm(String oaepPaddingDigestAlgorithm) {
        this.oaepPaddingDigestAlgorithm = oaepPaddingDigestAlgorithm;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withIvFieldName(String ivFieldName) {
        this.ivFieldName = ivFieldName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withOaepPaddingDigestAlgorithmFieldName(String oaepPaddingDigestAlgorithmFieldName) {
        this.oaepPaddingDigestAlgorithmFieldName = oaepPaddingDigestAlgorithmFieldName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptedKeyFieldName(String encryptedKeyFieldName) {
        this.encryptedKeyFieldName = encryptedKeyFieldName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptedValueFieldName(String encryptedValueFieldName) {
        this.encryptedValueFieldName = encryptedValueFieldName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionCertificateFingerprintFieldName(String encryptionCertificateFingerprintFieldName) {
        this.encryptionCertificateFingerprintFieldName = encryptionCertificateFingerprintFieldName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionKeyFingerprintFieldName(String encryptionKeyFingerprintFieldName) {
        this.encryptionKeyFingerprintFieldName = encryptionKeyFingerprintFieldName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withFieldValueEncoding(FieldLevelEncryptionConfig.FieldValueEncoding fieldValueEncoding) {
        this.fieldValueEncoding = fieldValueEncoding;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withIvHeaderName(String ivHeaderName) {
        this.ivHeaderName = ivHeaderName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withOaepPaddingDigestAlgorithmHeaderName(String oaepPaddingDigestAlgorithmHeaderName) {
        this.oaepPaddingDigestAlgorithmHeaderName = oaepPaddingDigestAlgorithmHeaderName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptedKeyHeaderName(String encryptedKeyHeaderName) {
        this.encryptedKeyHeaderName = encryptedKeyHeaderName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionCertificateFingerprintHeaderName(String encryptionCertificateFingerprintHeaderName) {
        this.encryptionCertificateFingerprintHeaderName = encryptionCertificateFingerprintHeaderName;
        return this;
    }

    public FieldLevelEncryptionConfigBuilder withEncryptionKeyFingerprintHeaderName(String encryptionKeyFingerprintHeaderName) {
        this.encryptionKeyFingerprintHeaderName = encryptionKeyFingerprintHeaderName;
        return this;
    }

    public FieldLevelEncryptionConfig build() throws EncryptionException {
        this.checkJsonPathParameterValues();
        this.checkParameterValues();
        this.checkParameterConsistency();
        this.computeEncryptionCertificateFingerprintWhenNeeded();
        this.computeEncryptionKeyFingerprintWhenNeeded();
        FieldLevelEncryptionConfig config = new FieldLevelEncryptionConfig();
        config.encryptionCertificateFingerprintFieldName = this.encryptionCertificateFingerprintFieldName;
        config.encryptionKeyFingerprintFieldName = this.encryptionKeyFingerprintFieldName;
        config.encryptionCertificateFingerprint = this.encryptionCertificateFingerprint;
        config.encryptionKeyFingerprint = this.encryptionKeyFingerprint;
        config.decryptionKey = this.decryptionKey;
        config.encryptionPaths = this.encryptionPaths;
        config.encryptionCertificate = this.encryptionCertificate;
        config.oaepPaddingDigestAlgorithm = this.oaepPaddingDigestAlgorithm;
        config.ivFieldName = this.ivFieldName;
        config.oaepPaddingDigestAlgorithmFieldName = this.oaepPaddingDigestAlgorithmFieldName;
        config.decryptionPaths = this.decryptionPaths;
        config.encryptedKeyFieldName = this.encryptedKeyFieldName;
        config.fieldValueEncoding = this.fieldValueEncoding;
        config.encryptedValueFieldName = this.encryptedValueFieldName;
        config.ivHeaderName = this.ivHeaderName;
        config.oaepPaddingDigestAlgorithmHeaderName = this.oaepPaddingDigestAlgorithmHeaderName;
        config.encryptedKeyHeaderName = this.encryptedKeyHeaderName;
        config.encryptionCertificateFingerprintHeaderName = this.encryptionCertificateFingerprintHeaderName;
        config.encryptionKeyFingerprintHeaderName = this.encryptionKeyFingerprintHeaderName;
        return config;
    }

    private void checkJsonPathParameterValues() {
        for (Map.Entry<String, String> entry : this.decryptionPaths.entrySet()) {
            if (JsonPath.isPathDefinite((String)entry.getKey()) && JsonPath.isPathDefinite((String)entry.getValue())) continue;
            throw new IllegalArgumentException("JSON paths for decryption must point to a single item!");
        }
        for (Map.Entry<String, String> entry : this.encryptionPaths.entrySet()) {
            if (JsonPath.isPathDefinite((String)entry.getKey()) && JsonPath.isPathDefinite((String)entry.getValue())) continue;
            throw new IllegalArgumentException("JSON paths for encryption must point to a single item!");
        }
    }

    private void checkParameterValues() {
        if (this.oaepPaddingDigestAlgorithm == null) {
            throw new IllegalArgumentException("The digest algorithm for OAEP cannot be null!");
        }
        if (!MGF1ParameterSpec.SHA256.getDigestAlgorithm().equals(this.oaepPaddingDigestAlgorithm) && !MGF1ParameterSpec.SHA512.getDigestAlgorithm().equals(this.oaepPaddingDigestAlgorithm)) {
            throw new IllegalArgumentException(String.format("Unsupported OAEP digest algorithm: %s!", this.oaepPaddingDigestAlgorithm));
        }
        if (this.fieldValueEncoding == null) {
            throw new IllegalArgumentException("Value encoding for fields and headers cannot be null!");
        }
        if (this.ivFieldName == null && this.ivHeaderName == null) {
            throw new IllegalArgumentException("At least one of IV field name or IV header name must be set!");
        }
        if (this.encryptedKeyFieldName == null && this.encryptedKeyHeaderName == null) {
            throw new IllegalArgumentException("At least one of encrypted key field name or encrypted key header name must be set!");
        }
        if (this.encryptedValueFieldName == null) {
            throw new IllegalArgumentException("Encrypted value field name cannot be null!");
        }
    }

    private void checkParameterConsistency() {
        if (!this.decryptionPaths.isEmpty() && this.decryptionKey == null) {
            throw new IllegalArgumentException("Can't decrypt without decryption key!");
        }
        if (!this.encryptionPaths.isEmpty() && this.encryptionCertificate == null) {
            throw new IllegalArgumentException("Can't encrypt without encryption key!");
        }
        if (this.ivHeaderName != null && this.encryptedKeyHeaderName == null || this.ivHeaderName == null && this.encryptedKeyHeaderName != null) {
            throw new IllegalArgumentException("IV header name and encrypted key header name must be both set or both unset!");
        }
        if (this.ivFieldName != null && this.encryptedKeyFieldName == null || this.ivFieldName == null && this.encryptedKeyFieldName != null) {
            throw new IllegalArgumentException("IV field name and encrypted key field name must be both set or both unset!");
        }
    }

    private void computeEncryptionCertificateFingerprintWhenNeeded() throws EncryptionException {
        try {
            if (this.encryptionCertificate == null || !StringUtils.isNullOrEmpty(this.encryptionCertificateFingerprint)) {
                return;
            }
            byte[] certificateFingerprintBytes = FieldLevelEncryptionConfigBuilder.sha256digestBytes(this.encryptionCertificate.getEncoded());
            this.encryptionCertificateFingerprint = EncodingUtils.encodeBytes(certificateFingerprintBytes, FieldLevelEncryptionConfig.FieldValueEncoding.HEX);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to compute encryption certificate fingerprint!", e);
        }
    }

    private void computeEncryptionKeyFingerprintWhenNeeded() throws EncryptionException {
        try {
            if (this.encryptionCertificate == null || !StringUtils.isNullOrEmpty(this.encryptionKeyFingerprint)) {
                return;
            }
            byte[] keyFingerprintBytes = FieldLevelEncryptionConfigBuilder.sha256digestBytes(this.encryptionCertificate.getPublicKey().getEncoded());
            this.encryptionKeyFingerprint = EncodingUtils.encodeBytes(keyFingerprintBytes, FieldLevelEncryptionConfig.FieldValueEncoding.HEX);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to compute encryption key fingerprint!", e);
        }
    }

    private static byte[] sha256digestBytes(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes);
        return messageDigest.digest();
    }
}

