/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.utils.FeignUtils;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class OpenFeignFieldLevelEncryptionDecoder
implements Decoder {
    private final FieldLevelEncryptionConfig config;
    private final Decoder delegate;

    public OpenFeignFieldLevelEncryptionDecoder(FieldLevelEncryptionConfig config, Decoder delegate) {
        this.config = config;
        this.delegate = delegate;
    }

    public Object decode(Response response, Type type) throws IOException {
        try {
            String decryptedPayload;
            Response.Body body = response.body();
            if (body == null || body.length() <= 0) {
                return this.delegate.decode(response, type);
            }
            String responsePayload = Util.toString((Reader)body.asReader());
            if (this.config.useHttpHeaders()) {
                String ivValue = FeignUtils.readHeader(response, this.config.getIvHeaderName());
                response = FeignUtils.removeHeader(response, this.config.getIvHeaderName());
                String oaepPaddingDigestAlgorithmValue = FeignUtils.readHeader(response, this.config.getOaepPaddingDigestAlgorithmHeaderName());
                response = FeignUtils.removeHeader(response, this.config.getOaepPaddingDigestAlgorithmHeaderName());
                String encryptedKeyValue = FeignUtils.readHeader(response, this.config.getEncryptedKeyHeaderName());
                response = FeignUtils.removeHeader(response, this.config.getEncryptedKeyHeaderName());
                response = FeignUtils.removeHeader(response, this.config.getEncryptionCertificateFingerprintHeaderName());
                response = FeignUtils.removeHeader(response, this.config.getEncryptionKeyFingerprintHeaderName());
                FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, this.config);
                decryptedPayload = FieldLevelEncryption.decryptPayload(responsePayload, this.config, params);
            } else {
                decryptedPayload = FieldLevelEncryption.decryptPayload(responsePayload, this.config);
            }
            response = FeignUtils.updateHeader(response, "Content-Length", String.valueOf(decryptedPayload.length()));
            response = response.toBuilder().body(decryptedPayload, StandardCharsets.UTF_8).build();
        }
        catch (EncryptionException e) {
            throw new DecodeException("Failed to intercept and decrypt response!", (Throwable)e);
        }
        return this.delegate.decode(response, type);
    }
}

