/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.encryption.JsonParser;
import com.mastercard.developer.encryption.aes.AESCBC;
import com.mastercard.developer.utils.EncodingUtils;
import com.mastercard.developer.utils.EncryptionUtils;
import com.mastercard.developer.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;

public class FieldLevelEncryption {
    private FieldLevelEncryption() {
    }

    public static String encryptPayload(String payload, FieldLevelEncryptionConfig config) throws EncryptionException {
        return FieldLevelEncryption.encryptPayload(payload, config, null);
    }

    public static String encryptPayload(String payload, FieldLevelEncryptionConfig config, Object params) throws EncryptionException {
        try {
            DocumentContext payloadContext = JsonPath.parse((String)payload, (Configuration)JsonParser.jsonPathConfig);
            for (Map.Entry entry : config.encryptionPaths.entrySet()) {
                String jsonPathIn = (String)entry.getKey();
                String jsonPathOut = (String)entry.getValue();
                FieldLevelEncryption.encryptPayloadPath(payloadContext, jsonPathIn, jsonPathOut, config, (FieldLevelEncryptionParams)params);
            }
            return payloadContext.jsonString();
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Payload encryption failed!", e);
        }
    }

    public static String decryptPayload(String payload, FieldLevelEncryptionConfig config) throws EncryptionException {
        return FieldLevelEncryption.decryptPayload(payload, config, null);
    }

    public static String decryptPayload(String payload, FieldLevelEncryptionConfig config, Object params) throws EncryptionException {
        try {
            DocumentContext payloadContext = JsonPath.parse((String)payload, (Configuration)JsonParser.jsonPathConfig);
            for (Map.Entry entry : config.decryptionPaths.entrySet()) {
                String jsonPathIn = (String)entry.getKey();
                String jsonPathOut = (String)entry.getValue();
                FieldLevelEncryption.decryptPayloadPath(payloadContext, jsonPathIn, jsonPathOut, config, (FieldLevelEncryptionParams)params);
            }
            return payloadContext.jsonString();
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Payload decryption failed!", e);
        }
    }

    private static void encryptPayloadPath(DocumentContext payloadContext, String jsonPathIn, String jsonPathOut, FieldLevelEncryptionConfig config, FieldLevelEncryptionParams params) throws GeneralSecurityException, EncryptionException {
        Object inJsonElement = JsonParser.readJsonElement(payloadContext, jsonPathIn);
        if (inJsonElement == null) {
            return;
        }
        if (params == null) {
            params = FieldLevelEncryptionParams.generate(config);
        }
        String inJsonString = EncryptionUtils.sanitizeJson(JsonParser.jsonEngine.toJsonString(inJsonElement));
        byte[] inJsonBytes = null;
        try {
            inJsonBytes = inJsonString.getBytes(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] encryptedValueBytes = AESCBC.cipher(params.getSecretKey(), params.getIvSpec(), inJsonBytes, 1);
        String encryptedValue = EncodingUtils.encodeBytes(encryptedValueBytes, config.fieldValueEncoding);
        if (!"$".equals(jsonPathIn)) {
            payloadContext.delete(jsonPathIn, new Predicate[0]);
        } else {
            ArrayList<String> propertyKeys = new ArrayList<String>(JsonParser.jsonEngine.getPropertyKeys(inJsonElement));
            for (String key : propertyKeys) {
                payloadContext.delete(jsonPathIn + "." + key, new Predicate[0]);
            }
        }
        JsonParser.checkOrCreateOutObject(payloadContext, jsonPathOut);
        payloadContext.put(jsonPathOut, config.encryptedValueFieldName, (Object)encryptedValue, new Predicate[0]);
        if (!StringUtils.isNullOrEmpty(config.ivFieldName)) {
            payloadContext.put(jsonPathOut, config.ivFieldName, (Object)params.getIvValue(), new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.encryptedKeyFieldName)) {
            payloadContext.put(jsonPathOut, config.encryptedKeyFieldName, (Object)params.getEncryptedKeyValue(), new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.encryptionCertificateFingerprintFieldName)) {
            payloadContext.put(jsonPathOut, config.encryptionCertificateFingerprintFieldName, (Object)config.encryptionCertificateFingerprint, new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.encryptionKeyFingerprintFieldName)) {
            payloadContext.put(jsonPathOut, config.encryptionKeyFingerprintFieldName, (Object)config.encryptionKeyFingerprint, new Predicate[0]);
        }
        if (!StringUtils.isNullOrEmpty(config.oaepPaddingDigestAlgorithmFieldName)) {
            payloadContext.put(jsonPathOut, config.oaepPaddingDigestAlgorithmFieldName, (Object)params.getOaepPaddingDigestAlgorithmValue(), new Predicate[0]);
        }
    }

    private static void decryptPayloadPath(DocumentContext payloadContext, String jsonPathIn, String jsonPathOut, FieldLevelEncryptionConfig config, FieldLevelEncryptionParams params) throws GeneralSecurityException, EncryptionException {
        JsonProvider jsonProvider = JsonParser.jsonPathConfig.jsonProvider();
        Object inJsonObject = JsonParser.readJsonObject(payloadContext, jsonPathIn);
        if (inJsonObject == null) {
            return;
        }
        Object encryptedValueJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptedValueFieldName);
        if (JsonParser.jsonEngine.isNullOrEmptyJson(encryptedValueJsonElement)) {
            return;
        }
        if (!config.useHttpPayloads() && params == null) {
            throw new IllegalStateException("Encryption params have to be set when not stored in HTTP payloads!");
        }
        if (params == null) {
            Object oaepDigestAlgorithmJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.oaepPaddingDigestAlgorithmFieldName);
            String oaepDigestAlgorithm = JsonParser.jsonEngine.isNullOrEmptyJson(oaepDigestAlgorithmJsonElement) ? config.oaepPaddingDigestAlgorithm : JsonParser.jsonEngine.toJsonString(oaepDigestAlgorithmJsonElement);
            Object encryptedKeyJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptedKeyFieldName);
            Object ivJsonElement = FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.ivFieldName);
            FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptionCertificateFingerprintFieldName);
            FieldLevelEncryption.readAndDeleteJsonKey(payloadContext, jsonPathIn, inJsonObject, config.encryptionKeyFingerprintFieldName);
            params = new FieldLevelEncryptionParams(JsonParser.jsonEngine.toJsonString(ivJsonElement), JsonParser.jsonEngine.toJsonString(encryptedKeyJsonElement), oaepDigestAlgorithm, config);
        }
        byte[] encryptedValueBytes = EncodingUtils.decodeValue(JsonParser.jsonEngine.toJsonString(encryptedValueJsonElement), config.fieldValueEncoding);
        byte[] decryptedValueBytes = AESCBC.cipher(params.getSecretKey(), params.getIvSpec(), encryptedValueBytes, 2);
        String decryptedValue = new String(decryptedValueBytes, StandardCharsets.UTF_8);
        decryptedValue = EncryptionUtils.sanitizeJson(decryptedValue);
        JsonParser.checkOrCreateOutObject(payloadContext, jsonPathOut);
        JsonParser.addDecryptedDataToPayload(payloadContext, decryptedValue, jsonPathOut);
        Object inJsonElement = JsonParser.readJsonElement(payloadContext, jsonPathIn);
        if (0 == jsonProvider.length(inJsonElement) && !"$".equals(jsonPathIn)) {
            payloadContext.delete(jsonPathIn, new Predicate[0]);
        }
    }

    private static Object readAndDeleteJsonKey(DocumentContext context, String objectPath, Object object, String key) {
        if (null == key) {
            return null;
        }
        JsonProvider jsonProvider = JsonParser.jsonPathConfig.jsonProvider();
        Object value = jsonProvider.getMapValue(object, key);
        context.delete(objectPath + "." + key, new Predicate[0]);
        return value;
    }
}

