/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionConfigBuilder;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.JweConfig;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collections;

public class JweConfigBuilder
extends EncryptionConfigBuilder {
    public static JweConfigBuilder aJweEncryptionConfig() {
        return new JweConfigBuilder();
    }

    public JweConfig build() throws EncryptionException {
        this.checkParameterValues();
        this.computeEncryptionKeyFingerprintWhenNeeded();
        this.checkJsonPathParameterValues();
        JweConfig config = new JweConfig();
        config.encryptionCertificate = this.encryptionCertificate;
        config.encryptionKeyFingerprint = this.encryptionKeyFingerprint;
        config.decryptionKey = this.decryptionKey;
        config.encryptionPaths = this.encryptionPaths.isEmpty() ? Collections.singletonMap("$", "$") : this.encryptionPaths;
        config.decryptionPaths = this.decryptionPaths.isEmpty() ? Collections.singletonMap("$.encryptedData", "$") : this.decryptionPaths;
        config.encryptedValueFieldName = this.encryptedValueFieldName == null ? "encryptedData" : this.encryptedValueFieldName;
        config.scheme = EncryptionConfig.Scheme.JWE;
        return config;
    }

    public JweConfigBuilder withEncryptionCertificate(Certificate encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
        return this;
    }

    public JweConfigBuilder withDecryptionKey(PrivateKey decryptionKey) {
        this.decryptionKey = decryptionKey;
        return this;
    }

    public JweConfigBuilder withEncryptionPath(String jsonPathIn, String jsonPathOut) {
        this.encryptionPaths.put(jsonPathIn, jsonPathOut);
        return this;
    }

    public JweConfigBuilder withDecryptionPath(String jsonPathIn, String jsonPathOut) {
        this.decryptionPaths.put(jsonPathIn, jsonPathOut);
        return this;
    }

    public JweConfigBuilder withEncryptedValueFieldName(String encryptedValueFieldName) {
        this.encryptedValueFieldName = encryptedValueFieldName;
        return this;
    }

    private void checkParameterValues() {
        if (this.decryptionKey == null && this.encryptionCertificate == null) {
            throw new IllegalArgumentException("You must include at least an encryption certificate or a decryption key");
        }
    }
}

