/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.interceptors.OkHttp2FieldLevelEncryptionInterceptor;
import com.mastercard.developer.interceptors.OkHttp2JweInterceptor;
import com.mastercard.developer.utils.StringUtils;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;

public abstract class OkHttp2EncryptionInterceptor
implements Interceptor {
    protected abstract String encryptPayload(Request var1, Request.Builder var2, String var3) throws EncryptionException;

    protected abstract String decryptPayload(Response var1, Response.Builder var2, String var3) throws EncryptionException;

    public static OkHttp2EncryptionInterceptor from(EncryptionConfig config) {
        return config.getScheme().equals((Object)EncryptionConfig.Scheme.JWE) ? new OkHttp2JweInterceptor(config) : new OkHttp2FieldLevelEncryptionInterceptor(config);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request encryptedRequest = this.handleRequest(chain.request());
        Response encryptedResponse = chain.proceed(encryptedRequest);
        return this.handleResponse(encryptedResponse);
    }

    private Request handleRequest(Request request) throws IOException {
        try {
            String requestPayload;
            RequestBody requestBody = request.body();
            if (null == requestBody || requestBody.contentLength() == 0L) {
                return request;
            }
            try (Buffer buffer = new Buffer();){
                request.body().writeTo((BufferedSink)buffer);
                requestPayload = buffer.readUtf8();
            }
            Request.Builder requestBuilder = request.newBuilder();
            String encryptedPayload = this.encryptPayload(request, requestBuilder, requestPayload);
            RequestBody encryptedBody = RequestBody.create((MediaType)requestBody.contentType(), (String)encryptedPayload);
            return requestBuilder.method(request.method(), encryptedBody).header("Content-Length", String.valueOf(encryptedBody.contentLength())).build();
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and encrypt request!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response handleResponse(Response response) throws IOException {
        try {
            ResponseBody responseBody = response.body();
            if (null == responseBody) {
                return response;
            }
            String responsePayload = responseBody.string();
            if (StringUtils.isNullOrEmpty(responsePayload)) {
                return response;
            }
            Response.Builder responseBuilder = response.newBuilder();
            String decryptedPayload = this.decryptPayload(response, responseBuilder, responsePayload);
            try (ResponseBody decryptedBody = ResponseBody.create((MediaType)responseBody.contentType(), (String)decryptedPayload);){
                Response response2 = responseBuilder.body(decryptedBody).header("Content-Length", String.valueOf(decryptedBody.contentLength())).build();
                return response2;
            }
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and decrypt response!", e);
        }
    }
}

