/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.JsonPath;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.utils.EncodingUtils;
import com.mastercard.developer.utils.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

abstract class EncryptionConfigBuilder {
    Certificate encryptionCertificate;
    String encryptionKeyFingerprint;
    PrivateKey decryptionKey;
    FieldLevelEncryptionConfig.FieldValueEncoding fieldValueEncoding;
    Map<String, String> encryptionPaths = new HashMap<String, String>();
    Map<String, String> decryptionPaths = new HashMap<String, String>();
    String encryptedValueFieldName;

    EncryptionConfigBuilder() {
    }

    void computeEncryptionKeyFingerprintWhenNeeded() throws EncryptionException {
        try {
            if (this.encryptionCertificate == null || !StringUtils.isNullOrEmpty(this.encryptionKeyFingerprint)) {
                return;
            }
            byte[] keyFingerprintBytes = EncryptionConfigBuilder.sha256digestBytes(this.encryptionCertificate.getPublicKey().getEncoded());
            this.encryptionKeyFingerprint = EncodingUtils.encodeBytes(keyFingerprintBytes, FieldLevelEncryptionConfig.FieldValueEncoding.HEX);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to compute encryption key fingerprint!", e);
        }
    }

    static byte[] sha256digestBytes(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes);
        return messageDigest.digest();
    }

    void checkJsonPathParameterValues() {
        for (Map.Entry<String, String> entry : this.decryptionPaths.entrySet()) {
            if (JsonPath.isPathDefinite((String)entry.getKey()) && JsonPath.isPathDefinite((String)entry.getValue())) continue;
            throw new IllegalArgumentException("JSON paths for decryption must point to a single item!");
        }
        for (Map.Entry<String, String> entry : this.encryptionPaths.entrySet()) {
            if (JsonPath.isPathDefinite((String)entry.getKey()) && JsonPath.isPathDefinite((String)entry.getValue())) continue;
            throw new IllegalArgumentException("JSON paths for encryption must point to a single item!");
        }
    }
}

