/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.JsonPath;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.utils.EncodingUtils;
import com.mastercard.developer.utils.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

abstract class EncryptionConfigBuilder {
    protected Certificate encryptionCertificate;
    protected String encryptionKeyFingerprint;
    protected PrivateKey decryptionKey;
    protected Map<String, String> encryptionPaths = new HashMap<String, String>();
    protected Map<String, String> decryptionPaths = new HashMap<String, String>();
    protected String encryptedValueFieldName;

    EncryptionConfigBuilder() {
    }

    void computeEncryptionKeyFingerprintWhenNeeded() throws EncryptionException {
        try {
            if (this.encryptionCertificate == null || !StringUtils.isNullOrEmpty(this.encryptionKeyFingerprint)) {
                return;
            }
            byte[] keyFingerprintBytes = EncryptionConfigBuilder.sha256digestBytes(this.encryptionCertificate.getPublicKey().getEncoded());
            this.encryptionKeyFingerprint = EncodingUtils.encodeBytes(keyFingerprintBytes, FieldLevelEncryptionConfig.FieldValueEncoding.HEX);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to compute encryption key fingerprint!", e);
        }
    }

    static byte[] sha256digestBytes(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes);
        return messageDigest.digest();
    }

    void checkJsonPathParameterValues() {
        for (Map.Entry<String, String> entry : this.decryptionPaths.entrySet()) {
            if (entry.getKey().contains("[*]") || entry.getValue().contains("[*]")) {
                if (!entry.getKey().contains("[*]") || !entry.getValue().contains("[*]")) {
                    throw new IllegalArgumentException("JSON paths for decryption with wildcard must both contain a wildcard!");
                }
                if (entry.getKey().split("[*]", -1).length - 1 <= 1 && entry.getValue().split("[*]", -1).length - 1 <= 1) continue;
                throw new IllegalArgumentException("JSON paths for decryption with can only contain one wildcard!");
            }
            if (JsonPath.isPathDefinite((String)entry.getKey()) && JsonPath.isPathDefinite((String)entry.getValue())) continue;
            throw new IllegalArgumentException("JSON paths for decryption must point to a single item!");
        }
        for (Map.Entry<String, String> entry : this.encryptionPaths.entrySet()) {
            if (entry.getKey().contains("[*]") || entry.getValue().contains("[*]")) {
                if (!entry.getKey().contains("[*]") || !entry.getValue().contains("[*]")) {
                    throw new IllegalArgumentException("JSON paths for encryption with wildcard must both contain a wildcard!");
                }
                if (entry.getKey().split("[*]", -1).length - 1 <= 1 && entry.getValue().split("[*]", -1).length - 1 <= 1) continue;
                throw new IllegalArgumentException("JSON paths for encryption with can only contain one wildcard!");
            }
            if (JsonPath.isPathDefinite((String)entry.getKey()) && JsonPath.isPathDefinite((String)entry.getValue())) continue;
            throw new IllegalArgumentException("JSON paths for encryption must point to a single item!");
        }
    }
}

