/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.aes.AESEncryption;
import com.mastercard.developer.encryption.rsa.RSA;
import com.mastercard.developer.utils.EncodingUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class FieldLevelEncryptionParams {
    private static final Integer SYMMETRIC_KEY_SIZE = 128;
    static final String SYMMETRIC_KEY_TYPE = "AES";
    private final String ivValue;
    private final String encryptedKeyValue;
    private final String oaepPaddingDigestAlgorithmValue;
    private final FieldLevelEncryptionConfig config;
    private Key secretKey;
    private IvParameterSpec ivParameterSpec;

    public FieldLevelEncryptionParams(String ivValue, String encryptedKeyValue, String oaepPaddingDigestAlgorithmValue, FieldLevelEncryptionConfig config) {
        this.ivValue = ivValue;
        this.encryptedKeyValue = encryptedKeyValue;
        this.oaepPaddingDigestAlgorithmValue = oaepPaddingDigestAlgorithmValue;
        this.config = config;
    }

    public static FieldLevelEncryptionParams generate(FieldLevelEncryptionConfig config) throws EncryptionException {
        IvParameterSpec ivParameterSpec = AESEncryption.generateIv();
        String ivSpecValue = EncodingUtils.encodeBytes(ivParameterSpec.getIV(), config.fieldValueEncoding);
        SecretKey secretKey = FieldLevelEncryptionParams.generateSecretKey();
        byte[] encryptedSecretKeyBytes = RSA.wrapSecretKey(config.encryptionCertificate.getPublicKey(), secretKey, config.oaepPaddingDigestAlgorithm);
        String encryptedKeyValue = EncodingUtils.encodeBytes(encryptedSecretKeyBytes, config.fieldValueEncoding);
        String oaepPaddingDigestAlgorithmValue = config.oaepPaddingDigestAlgorithm.replace("-", "");
        FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivSpecValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, config);
        params.secretKey = secretKey;
        params.ivParameterSpec = ivParameterSpec;
        return params;
    }

    public String getIvValue() {
        return this.ivValue;
    }

    public String getEncryptedKeyValue() {
        return this.encryptedKeyValue;
    }

    public String getOaepPaddingDigestAlgorithmValue() {
        return this.oaepPaddingDigestAlgorithmValue;
    }

    Key getSecretKey() throws EncryptionException {
        try {
            if (this.secretKey != null) {
                return this.secretKey;
            }
            byte[] encryptedSecretKeyBytes = EncodingUtils.decodeValue(this.encryptedKeyValue, this.config.fieldValueEncoding);
            this.secretKey = RSA.unwrapSecretKey(this.config.decryptionKey, encryptedSecretKeyBytes, this.oaepPaddingDigestAlgorithmValue);
            return this.secretKey;
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to decode and unwrap the provided secret key value!", e);
        }
    }

    IvParameterSpec getIvSpec() throws EncryptionException {
        try {
            if (this.ivParameterSpec != null) {
                return this.ivParameterSpec;
            }
            byte[] ivByteArray = EncodingUtils.decodeValue(this.ivValue, this.config.fieldValueEncoding);
            this.ivParameterSpec = new IvParameterSpec(ivByteArray);
            return this.ivParameterSpec;
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to decode the provided IV value!", e);
        }
    }

    private static SecretKey generateSecretKey() throws EncryptionException {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(SYMMETRIC_KEY_TYPE);
            generator.init(SYMMETRIC_KEY_SIZE);
            return generator.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Failed to generate a secret key!", e);
        }
    }
}

