/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.interceptors.HttpExecuteFieldLevelEncryptionInterceptor;
import com.mastercard.developer.interceptors.HttpExecuteJweInterceptor;
import com.mastercard.developer.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;

public abstract class HttpExecuteEncryptionInterceptor
implements HttpExecuteInterceptor,
HttpResponseInterceptor {
    protected abstract String encryptPayload(HttpHeaders var1, String var2) throws EncryptionException;

    protected abstract String decryptPayload(HttpHeaders var1, String var2) throws EncryptionException;

    public static HttpExecuteEncryptionInterceptor from(EncryptionConfig config) {
        return config.getScheme().equals((Object)EncryptionConfig.Scheme.JWE) ? new HttpExecuteJweInterceptor(config) : new HttpExecuteFieldLevelEncryptionInterceptor(config){};
    }

    public void intercept(HttpRequest request) throws IOException {
        try {
            HttpContent content = request.getContent();
            if (null == content || content.getLength() == 0L) {
                return;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)outputStream);
            String requestPayload = outputStream.toString(StandardCharsets.UTF_8.name());
            HttpHeaders headers = request.getHeaders();
            String encryptedPayload = this.encryptPayload(headers, requestPayload);
            ByteArrayContent encryptedContent = new ByteArrayContent("application/json; charset=" + StandardCharsets.UTF_8.name(), encryptedPayload.getBytes());
            headers.setContentLength(Long.valueOf(encryptedContent.getLength()));
            request.setContent((HttpContent)encryptedContent);
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and encrypt request!", e);
        }
    }

    public void interceptResponse(HttpResponse response) throws IOException {
        try {
            String responsePayload = response.parseAsString();
            if (StringUtils.isNullOrEmpty(responsePayload)) {
                return;
            }
            HttpHeaders headers = response.getHeaders();
            String decryptedPayload = this.decryptPayload(headers, responsePayload);
            ByteArrayContent decryptedContent = new ByteArrayContent("application/json; charset=" + StandardCharsets.UTF_8.name(), decryptedPayload.getBytes());
            headers.setContentLength(Long.valueOf(decryptedContent.getLength()));
            Field contentField = response.getClass().getDeclaredField("content");
            contentField.setAccessible(true);
            contentField.set(response, decryptedContent.getInputStream());
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and decrypt response!", e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException("Failed to update response with decrypted payload!", e);
        }
    }

    static void removeHeader(HttpHeaders headers, String name) {
        if (name == null) {
            return;
        }
        headers.remove((Object)name);
    }

    static void updateHeader(HttpHeaders headers, String name, String value) {
        if (name == null) {
            return;
        }
        headers.remove((Object)name);
        headers.set(name, (Object)value);
    }
}

