/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.interceptors.OkHttpEncryptionInterceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpFieldLevelEncryptionInterceptor
extends OkHttpEncryptionInterceptor {
    private final FieldLevelEncryptionConfig config;

    public OkHttpFieldLevelEncryptionInterceptor(EncryptionConfig config) {
        this.config = (FieldLevelEncryptionConfig)config;
    }

    @Override
    protected String encryptPayload(Request request, Request.Builder requestBuilder, String requestPayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(this.config);
            OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getIvHeaderName(), params.getIvValue());
            OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
            OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getEncryptionCertificateFingerprintHeaderName(), this.config.getEncryptionCertificateFingerprint());
            OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getEncryptionKeyFingerprintHeaderName(), this.config.getEncryptionKeyFingerprint());
            OkHttpFieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
            return FieldLevelEncryption.encryptPayload(requestPayload, this.config, params);
        }
        return FieldLevelEncryption.encryptPayload(requestPayload, this.config);
    }

    @Override
    protected String decryptPayload(Response response, Response.Builder responseBuilder, String responsePayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            String ivValue = response.header(this.config.getIvHeaderName(), null);
            String oaepPaddingDigestAlgorithmValue = response.header(this.config.getOaepPaddingDigestAlgorithmHeaderName(), null);
            String encryptedKeyValue = response.header(this.config.getEncryptedKeyHeaderName(), null);
            OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getIvHeaderName());
            OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getEncryptedKeyHeaderName());
            OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getOaepPaddingDigestAlgorithmHeaderName());
            OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getEncryptionCertificateFingerprintHeaderName());
            OkHttpFieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getEncryptionKeyFingerprintHeaderName());
            FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, this.config);
            return FieldLevelEncryption.decryptPayload(responsePayload, this.config, params);
        }
        return FieldLevelEncryption.decryptPayload(responsePayload, this.config);
    }
}

