/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.mastercard.developer.json.JsonEngine;
import java.util.Collections;
import java.util.List;

public final class JsonParser {
    static JsonEngine jsonEngine;
    static Configuration jsonPathConfig;

    private JsonParser() {
    }

    public static synchronized Configuration withJsonEngine(JsonEngine jsonEngine) {
        JsonParser.jsonEngine = jsonEngine;
        jsonPathConfig = new Configuration.ConfigurationBuilder().jsonProvider(jsonEngine.getJsonProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
        return jsonPathConfig;
    }

    static void addDecryptedDataToPayload(DocumentContext payloadContext, String decryptedValue, String jsonPathOut) {
        JsonProvider jsonProvider = jsonPathConfig.jsonProvider();
        Object decryptedValueJsonElement = jsonEngine.parse(decryptedValue);
        if (!jsonEngine.isJsonObject(decryptedValueJsonElement)) {
            payloadContext.set(jsonPathOut, decryptedValueJsonElement, new Predicate[0]);
            return;
        }
        int length = jsonProvider.length(decryptedValueJsonElement);
        List<String> propertyKeys = 0 == length ? Collections.emptyList() : jsonProvider.getPropertyKeys(decryptedValueJsonElement);
        for (String key : propertyKeys) {
            JsonParser.deleteIfExists(payloadContext, jsonPathOut + "." + key);
            payloadContext.put(jsonPathOut, key, jsonProvider.getMapValue(decryptedValueJsonElement, key), new Predicate[0]);
        }
    }

    static void checkOrCreateOutObject(DocumentContext context, String jsonPathOutString) {
        Object outJsonObject = JsonParser.readJsonObject(context, jsonPathOutString);
        if (null != outJsonObject) {
            return;
        }
        String parentJsonPath = JsonEngine.getParentJsonPath(jsonPathOutString);
        Object parentJsonObject = JsonParser.readJsonObject(context, parentJsonPath);
        if (parentJsonObject == null) {
            throw new IllegalArgumentException(String.format("Parent path not found in payload: '%s'!", parentJsonPath));
        }
        outJsonObject = jsonPathConfig.jsonProvider().createMap();
        String elementKey = JsonEngine.getJsonElementKey(jsonPathOutString);
        context.put(parentJsonPath, elementKey, outJsonObject, new Predicate[0]);
    }

    static Object readJsonElement(DocumentContext context, String jsonPathString) {
        Object payloadJsonObject = context.json();
        JsonPath jsonPath = JsonPath.compile((String)jsonPathString, (Predicate[])new Predicate[0]);
        return jsonPath.read(payloadJsonObject, jsonPathConfig);
    }

    static Object readJsonObject(DocumentContext context, String jsonPathString) {
        Object jsonElement = JsonParser.readJsonElement(context, jsonPathString);
        if (jsonElement == null) {
            return null;
        }
        if (!jsonEngine.isJsonObject(jsonElement)) {
            throw new IllegalArgumentException(String.format("JSON object expected at path: '%s'!", jsonPathString));
        }
        return jsonElement;
    }

    static void deleteIfExists(DocumentContext context, String jsonPathString) {
        Object value = context.read(jsonPathString, new Predicate[0]);
        if (value != null) {
            context.delete(jsonPathString, new Predicate[0]);
        }
    }

    static {
        jsonPathConfig = JsonParser.withJsonEngine(JsonEngine.getDefault());
    }
}

