/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.interceptors.OkHttpFieldLevelEncryptionInterceptor;
import com.mastercard.developer.interceptors.OkHttpJweInterceptor;
import com.mastercard.developer.utils.StringUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public abstract class OkHttpEncryptionInterceptor
implements Interceptor {
    public static OkHttpEncryptionInterceptor from(EncryptionConfig config) {
        return config.getScheme().equals((Object)EncryptionConfig.Scheme.JWE) ? new OkHttpJweInterceptor(config) : new OkHttpFieldLevelEncryptionInterceptor(config);
    }

    protected abstract String encryptPayload(Request var1, Request.Builder var2, String var3) throws EncryptionException;

    protected abstract String decryptPayload(Response var1, Response.Builder var2, String var3) throws EncryptionException;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request encryptedRequest = this.handleRequest(chain.request());
        Response encryptedResponse = chain.proceed(encryptedRequest);
        return this.handleResponse(encryptedResponse);
    }

    private Request handleRequest(Request request) throws IOException {
        try {
            String requestPayload;
            RequestBody requestBody = request.body();
            if (null == requestBody || requestBody.contentLength() == 0L) {
                return request;
            }
            try (Buffer buffer = new Buffer();){
                request.body().writeTo((BufferedSink)buffer);
                requestPayload = buffer.readUtf8();
            }
            Request.Builder requestBuilder = request.newBuilder();
            String encryptedPayload = this.encryptPayload(request, requestBuilder, requestPayload);
            RequestBody encryptedBody = RequestBody.create((MediaType)requestBody.contentType(), (String)encryptedPayload);
            return requestBuilder.method(request.method(), encryptedBody).header("Content-Length", String.valueOf(encryptedBody.contentLength())).build();
        }
        catch (EncryptionException e) {
            throw new IOException("Failed to intercept and encrypt request!", e);
        }
    }

    private Response handleResponse(Response response) throws IOException {
        Response response2;
        block10: {
            ResponseBody responseBody = response.body();
            if (null == responseBody) {
                return response;
            }
            String responsePayload = responseBody.string();
            if (StringUtils.isNullOrEmpty(responsePayload)) {
                return response;
            }
            Response.Builder responseBuilder = response.newBuilder();
            String decryptedPayload = this.decryptPayload(response, responseBuilder, responsePayload);
            ResponseBody decryptedBody = ResponseBody.create((MediaType)responseBody.contentType(), (String)decryptedPayload);
            try {
                response2 = responseBuilder.body(decryptedBody).header("Content-Length", String.valueOf(decryptedBody.contentLength())).build();
                if (decryptedBody == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (decryptedBody != null) {
                        try {
                            decryptedBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EncryptionException e) {
                    throw new IOException("Failed to intercept and decrypt response!", e);
                }
            }
            decryptedBody.close();
        }
        return response2;
    }

    static void removeHeader(Response.Builder responseBuilder, String name) {
        if (name == null) {
            return;
        }
        responseBuilder.removeHeader(name);
    }

    static void updateHeader(Request.Builder requestBuilder, String name, String value) {
        if (name == null) {
            return;
        }
        requestBuilder.header(name, value);
    }
}

