/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption.aes;

import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.utils.ByteUtils;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryption {
    private AESEncryption() {
    }

    public static IvParameterSpec generateIv(Integer ivSize) throws EncryptionException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] ivBytes = new byte[ivSize.intValue()];
            secureRandom.nextBytes(ivBytes);
            return new IvParameterSpec(ivBytes);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Failed to generate an IV value!", e);
        }
    }

    public static SecretKeySpec generateCek(int bitLength) {
        SecureRandom random = new SecureRandom();
        byte[] cekMaterial = new byte[ByteUtils.byteLength(bitLength)];
        random.nextBytes(cekMaterial);
        return new SecretKeySpec(cekMaterial, "AES");
    }
}

