/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.interceptors.OkHttp2EncryptionInterceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp2FieldLevelEncryptionInterceptor
extends OkHttp2EncryptionInterceptor {
    private final FieldLevelEncryptionConfig config;

    public OkHttp2FieldLevelEncryptionInterceptor(EncryptionConfig config) {
        this.config = (FieldLevelEncryptionConfig)config;
    }

    @Override
    protected String encryptPayload(Request request, Request.Builder requestBuilder, String requestPayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(this.config);
            OkHttp2FieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getIvHeaderName(), params.getIvValue());
            OkHttp2FieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
            OkHttp2FieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getEncryptionCertificateFingerprintHeaderName(), this.config.getEncryptionCertificateFingerprint());
            OkHttp2FieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getEncryptionKeyFingerprintHeaderName(), this.config.getEncryptionKeyFingerprint());
            OkHttp2FieldLevelEncryptionInterceptor.updateHeader(requestBuilder, this.config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
            return FieldLevelEncryption.encryptPayload(requestPayload, this.config, params);
        }
        return FieldLevelEncryption.encryptPayload(requestPayload, this.config);
    }

    @Override
    protected String decryptPayload(Response response, Response.Builder responseBuilder, String responsePayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            String ivValue = response.header(this.config.getIvHeaderName());
            String oaepPaddingDigestAlgorithmValue = response.header(this.config.getOaepPaddingDigestAlgorithmHeaderName());
            String encryptedKeyValue = response.header(this.config.getEncryptedKeyHeaderName());
            OkHttp2FieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getIvHeaderName());
            OkHttp2FieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getEncryptedKeyHeaderName());
            OkHttp2FieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getOaepPaddingDigestAlgorithmHeaderName());
            OkHttp2FieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getEncryptionCertificateFingerprintHeaderName());
            OkHttp2FieldLevelEncryptionInterceptor.removeHeader(responseBuilder, this.config.getEncryptionKeyFingerprintHeaderName());
            FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, this.config);
            return FieldLevelEncryption.decryptPayload(responsePayload, this.config, params);
        }
        return FieldLevelEncryption.decryptPayload(responsePayload, this.config);
    }

    private static void removeHeader(Response.Builder responseBuilder, String name) {
        if (name == null) {
            return;
        }
        responseBuilder.removeHeader(name);
    }

    private static void updateHeader(Request.Builder requestBuilder, String name, String value) {
        if (name == null) {
            return;
        }
        requestBuilder.header(name, value);
    }
}

