/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.interceptors.OpenFeignFieldLevelEncryptionDecoder;
import com.mastercard.developer.interceptors.OpenFeignJweDecoder;
import com.mastercard.developer.utils.FeignUtils;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public abstract class OpenFeignDecoderExecutor
implements Decoder {
    private final Decoder delegate;

    public static OpenFeignDecoderExecutor from(EncryptionConfig config, Decoder delegate) {
        return config.getScheme().equals((Object)EncryptionConfig.Scheme.JWE) ? new OpenFeignJweDecoder(config, delegate) : new OpenFeignFieldLevelEncryptionDecoder(config, delegate);
    }

    OpenFeignDecoderExecutor(Decoder delegate) {
        this.delegate = delegate;
    }

    protected abstract String decryptPayload(Response var1, String var2) throws EncryptionException;

    public Object decode(Response response, Type type) throws IOException {
        try {
            Response.Body body = response.body();
            if (body == null || body.length() <= 0) {
                return this.delegate.decode(response, type);
            }
            String responsePayload = Util.toString((Reader)body.asReader(StandardCharsets.UTF_8));
            String decryptedPayload = this.decryptPayload(response, responsePayload);
            response = this.removeHeaders(response);
            response = FeignUtils.updateHeader(response, "Content-Length", String.valueOf(decryptedPayload.length()));
            response = response.toBuilder().body(decryptedPayload, StandardCharsets.UTF_8).build();
        }
        catch (EncryptionException e) {
            throw new DecodeException(response.status(), "Failed to intercept and decrypt response!", response.request(), (Throwable)e);
        }
        return this.delegate.decode(response, type);
    }

    protected Response removeHeaders(Response response) {
        return response;
    }
}

