/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.signers;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.mastercard.developer.oauth.OAuth;
import com.mastercard.developer.signers.AbstractSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.PrivateKey;

public class GoogleApiClientSigner
extends AbstractSigner {
    public GoogleApiClientSigner(String consumerKey, PrivateKey signingKey) {
        super(consumerKey, signingKey);
    }

    public GoogleApiClientSigner(Charset charset, String consumerKey, PrivateKey signingKey) {
        super(charset, consumerKey, signingKey);
    }

    public void sign(HttpRequest request) throws IOException {
        URI uri = request.getUrl().toURI();
        String method = request.getRequestMethod();
        String payload = null;
        HttpContent content = request.getContent();
        if (null != content && content.getLength() > 0L) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            content.writeTo((OutputStream)outputStream);
            payload = outputStream.toString(this.charset.name());
        }
        String authorizationHeader = OAuth.getAuthorizationHeader(uri, method, payload, this.charset, this.consumerKey, this.signingKey);
        request.getHeaders().setAuthorization(authorizationHeader);
    }
}

