/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.signers;

import com.mastercard.developer.oauth.OAuth;
import com.mastercard.developer.signers.AbstractSigner;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient4Signer
extends AbstractSigner {
    public ApacheHttpClient4Signer(String consumerKey, PrivateKey signingKey) {
        super(consumerKey, signingKey);
    }

    public void sign(HttpRequestBase req) throws IOException {
        HttpEntityEnclosingRequestBase requestBase;
        HttpEntity entity;
        String payload = null;
        Charset charset = Charset.defaultCharset();
        if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(req.getClass()) && (entity = (requestBase = (HttpEntityEnclosingRequestBase)req).getEntity()).getContentLength() > 0L) {
            if (!entity.isRepeatable()) {
                throw new IOException("The signer needs to read the request payload but the input stream of this request cannot be read multiple times. Please provide the payload using a separate argument or ensure that the entity is repeatable.");
            }
            ContentType contentType = ContentType.get((HttpEntity)entity);
            charset = contentType.getCharset();
            payload = EntityUtils.toString((HttpEntity)entity, (Charset)contentType.getCharset());
        }
        String authHeader = OAuth.getAuthorizationHeader(req.getURI(), req.getMethod(), payload, charset, this.consumerKey, this.signingKey);
        req.setHeader("Authorization", authHeader);
    }
}

