/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.signers;

import com.mastercard.developer.oauth.OAuth;
import com.mastercard.developer.signers.AbstractSigner;
import feign.RequestTemplate;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.PrivateKey;

public class OpenFeignSigner
extends AbstractSigner {
    private final String baseUri;

    public OpenFeignSigner(String consumerKey, PrivateKey signingKey, String baseUri) {
        super(consumerKey, signingKey);
        this.baseUri = baseUri;
    }

    public OpenFeignSigner(Charset charset, String consumerKey, PrivateKey signingKey, String baseUri) {
        super(charset, consumerKey, signingKey);
        this.baseUri = baseUri;
    }

    public void sign(RequestTemplate requestTemplate) {
        URI uri = URI.create(this.baseUri.replaceAll("/$", "") + requestTemplate.request().url());
        String method = requestTemplate.method();
        byte[] bodyBytes = requestTemplate.body();
        String payload = bodyBytes != null ? new String(bodyBytes, this.charset) : null;
        String authHeader = OAuth.getAuthorizationHeader(uri, method, payload, this.charset, this.consumerKey, this.signingKey);
        requestTemplate.header("Authorization", new String[]{authHeader});
    }
}

