/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.oauth;

import com.mastercard.developer.oauth.Util;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuth {
    public static final String EMPTY_STRING = "";
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final Logger LOG = Logger.getLogger(OAuth.class.getName());
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final int NONCE_LENGTH = 16;
    private static final String ALPHA_NUMERIC_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private OAuth() {
    }

    public static String getAuthorizationHeader(URI uri, String method, String payload, Charset charset, String consumerKey, PrivateKey signingKey) {
        TreeMap<String, List<String>> queryParams = OAuth.extractQueryParams(uri, charset);
        HashMap<String, String> oauthParams = new HashMap<String, String>();
        oauthParams.put("oauth_consumer_key", consumerKey);
        oauthParams.put("oauth_nonce", OAuth.getNonce());
        oauthParams.put("oauth_signature_method", "RSA-" + HASH_ALGORITHM.replace("-", EMPTY_STRING));
        oauthParams.put("oauth_timestamp", OAuth.getTimestamp());
        oauthParams.put("oauth_version", "1.0");
        oauthParams.put("oauth_body_hash", OAuth.getBodyHash(payload, charset, HASH_ALGORITHM));
        String paramString = OAuth.toOauthParamString(queryParams, oauthParams);
        String baseUri = OAuth.getBaseUriString(uri);
        String sbs = OAuth.getSignatureBaseString(method, baseUri, paramString, charset);
        String signature = OAuth.signSignatureBaseString(sbs, signingKey, charset);
        oauthParams.put("oauth_signature", Util.percentEncode(signature, charset));
        return OAuth.getAuthorizationString(oauthParams);
    }

    static String getSignatureBaseString(String httpMethod, String baseUri, String paramString, Charset charset) {
        String sbs = httpMethod.toUpperCase() + "&" + Util.percentEncode(baseUri, charset) + "&" + Util.percentEncode(paramString, charset);
        LOG.log(Level.FINE, "Generated SBS: {0}", sbs);
        return sbs;
    }

    static TreeMap<String, List<String>> extractQueryParams(URI uri, Charset charset) {
        String[] pairs;
        String decodedQueryString = uri.getQuery();
        String rawQueryString = uri.getRawQuery();
        if (decodedQueryString == null || decodedQueryString.isEmpty() || rawQueryString == null || rawQueryString.isEmpty()) {
            return new TreeMap<String, List<String>>();
        }
        boolean mustEncode = !decodedQueryString.equals(rawQueryString);
        TreeMap<String, List<String>> queryPairs = new TreeMap<String, List<String>>();
        for (String pair : pairs = decodedQueryString.split("&")) {
            String key;
            int idx = pair.indexOf(61);
            String string = key = idx > 0 ? pair.substring(0, idx) : pair;
            if (!queryPairs.containsKey(key)) {
                key = mustEncode ? Util.percentEncode(key, charset) : key;
                queryPairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : EMPTY_STRING;
            value = mustEncode ? Util.percentEncode(value, charset) : value;
            queryPairs.get(key).add(value);
        }
        return queryPairs;
    }

    static String toOauthParamString(SortedMap<String, List<String>> queryParamsMap, Map<String, String> oauthParamsMap) {
        TreeMap<String, List<String>> consolidatedParams = new TreeMap<String, List<String>>(queryParamsMap);
        for (Map.Entry<String, String> entry : oauthParamsMap.entrySet()) {
            if (consolidatedParams.containsKey(entry.getKey())) {
                consolidatedParams.get(entry.getKey()).add((String)entry.getValue());
                continue;
            }
            consolidatedParams.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
        }
        StringBuilder oauthParams = new StringBuilder();
        for (Map.Entry entry : consolidatedParams.entrySet()) {
            String key = (String)entry.getKey();
            if (((List)entry.getValue()).size() > 1) {
                Collections.sort((List)entry.getValue());
            }
            for (String value : (List)entry.getValue()) {
                oauthParams.append(key).append("=").append(value).append("&");
            }
        }
        int stringLength = oauthParams.length() - 1;
        if (oauthParams.charAt(stringLength) == '&') {
            oauthParams.deleteCharAt(stringLength);
        }
        return oauthParams.toString();
    }

    static String getNonce() {
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < 16; ++i) {
            sb.append(ALPHA_NUMERIC_CHARS.charAt(rnd.nextInt(ALPHA_NUMERIC_CHARS.length())));
        }
        return sb.toString();
    }

    private static String getTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    static String getBaseUriString(URI uri) {
        String path;
        int index;
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        if (("http".equals(scheme) && uri.getPort() == 80 || "https".equals(scheme) && uri.getPort() == 443) && (index = authority.lastIndexOf(58)) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    static String getBodyHash(String payload, Charset charset, String hashAlg) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to obtain " + hashAlg + " message digest", e);
        }
        digest.reset();
        byte[] byteArray = null == payload ? EMPTY_STRING.getBytes() : payload.getBytes(charset);
        byte[] hash = digest.digest(byteArray);
        return Util.b64Encode(hash);
    }

    static String signSignatureBaseString(String sbs, PrivateKey signingKey, Charset charset) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(signingKey);
            byte[] sbsBytes = sbs.getBytes(charset);
            signer.update(sbsBytes);
            byte[] signatureBytes = signer.sign();
            return Util.b64Encode(signatureBytes);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to RSA-SHA256 sign the given string with the provided key", e);
        }
    }

    private static String getAuthorizationString(Map<String, String> oauthParams) {
        StringBuilder header = new StringBuilder("OAuth ");
        for (Map.Entry<String, String> param : oauthParams.entrySet()) {
            header.append(param.getKey()).append("=\"").append(param.getValue()).append("\",");
        }
        header.deleteCharAt(header.length() - 1);
        return header.toString();
    }
}

