/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.signers;

import com.mastercard.developer.oauth.OAuth;
import com.mastercard.developer.signers.AbstractSigner;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import okio.Buffer;
import okio.BufferedSink;

public class OkHttp2Signer
extends AbstractSigner {
    public OkHttp2Signer(String consumerKey, PrivateKey signingKey) {
        super(StandardCharsets.UTF_8, consumerKey, signingKey);
    }

    public OkHttp2Signer(Charset charset, String consumerKey, PrivateKey signingKey) {
        super(charset, consumerKey, signingKey);
    }

    public void sign(Request.Builder req) throws IOException {
        Request builtRequest = req.build();
        URI uri = builtRequest.uri();
        String method = builtRequest.method();
        String payload = null;
        RequestBody body = builtRequest.body();
        if (null != body && body.contentLength() > 0L) {
            Buffer buffer = new Buffer();
            builtRequest.body().writeTo((BufferedSink)buffer);
            payload = buffer.readUtf8();
        }
        String authHeader = OAuth.getAuthorizationHeader(uri, method, payload, this.charset, this.consumerKey, this.signingKey);
        req.addHeader("Authorization", authHeader);
    }
}

