package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.Checkout;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class CheckoutApi {

 /**
   * Check out service
   * <p>This service is used to retrieve consumer&#39;s payment, shipping address, reward and 3-D Secure information from MasterPass. The checkout resource URL supplied by MasterPass must be decoded and consumed by the merchant as provided by MasterPass.</p>
   * @param pathid	the Checkout identifier.
   * @param oauthToken	the Access token, which is used to retrieve checkout data.
   * @return 	the Checkout.
   */
     public static Checkout show(String pathid, String oauthToken){
			return show( pathid,  oauthToken, MasterCardApiConfig.config());
	}
 
 
 /**
   * Check out service
   * <p>This service is used to retrieve consumer&#39;s payment, shipping address, reward and 3-D Secure information from MasterPass. The checkout resource URL supplied by MasterPass must be decoded and consumed by the merchant as provided by MasterPass.</p>
   * @param pathid	the Checkout identifier.
   * @param oauthToken	the Access token, which is used to retrieve checkout data.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the Checkout.
   */
     public static Checkout show(String pathid, String oauthToken, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/checkout/{pathid}";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 serviceRequest.pathParam("pathid",pathid);
	 
	 serviceRequest.header("oauth_token",oauthToken);
	 
	 
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"GET",Checkout.class);
	}
 
}
