package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.DecryptionResponse;
import com.mastercard.masterpass.merchant.model.DecryptionRequest;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class DecryptionApi {

 /**
   * Decryption Service
   * <p>Decryption Service Android SDK.</p>
   * @param decryptionRequest	the Decryption Service.
   * @return 	the DecryptionResponse.
   */
     public static DecryptionResponse create(DecryptionRequest decryptionRequest){
			return create( decryptionRequest, MasterCardApiConfig.config());
	}
 
 
 /**
   * Decryption Service
   * <p>Decryption Service Android SDK.</p>
   * @param decryptionRequest	the Decryption Service.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the DecryptionResponse.
   */
     public static DecryptionResponse create(DecryptionRequest decryptionRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/decrypt";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(decryptionRequest);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",DecryptionResponse.class);
	}
 
}
