package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.ExpressCheckoutResponse;
import com.mastercard.masterpass.merchant.model.ExpressCheckoutRequest;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class ExpressCheckoutApi {

 /**
   * Express Checkout Service
   * <p>This provides qualified merchants with ability to provide the express checkout experience (wherein the consumer does not have to have log into the MasterPass wallet and thereby remains within the merchant experience throughout the transaction) to its MasterPass consumers.</p>
   * @param oauthToken	the Long access token, which is used to retrieve precheckout data.
   * @param expressCheckoutRequest	the Express Checkout Request.
   * @return 	the ExpressCheckoutResponse.
   */
     public static ExpressCheckoutResponse create(String oauthToken, ExpressCheckoutRequest expressCheckoutRequest){
			return create( oauthToken,  expressCheckoutRequest, MasterCardApiConfig.config());
	}
 
 
 /**
   * Express Checkout Service
   * <p>This provides qualified merchants with ability to provide the express checkout experience (wherein the consumer does not have to have log into the MasterPass wallet and thereby remains within the merchant experience throughout the transaction) to its MasterPass consumers.</p>
   * @param oauthToken	the Long access token, which is used to retrieve precheckout data.
   * @param expressCheckoutRequest	the Express Checkout Request.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the ExpressCheckoutResponse.
   */
     public static ExpressCheckoutResponse create(String oauthToken, ExpressCheckoutRequest expressCheckoutRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/expresscheckout";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 serviceRequest.header("oauth_token",oauthToken);
	 
	 serviceRequest.requestBody(expressCheckoutRequest);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",ExpressCheckoutResponse.class);
	}
 
}
