package com.mastercard.masterpass.merchant;

import com.mastercard.masterpass.merchant.model.MerchantInitializationResponse;
import com.mastercard.masterpass.merchant.model.MerchantInitializationRequest;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.masterpass.merchant.impl.APITrackerImpl;

public class MerchantInitializationApi {

 /**
   * Merchant Initialization Service
   * <p>This service is used to secure Lightbox connections between merchant and MasterPass. This service requires a request token (OAuthToken). This service call should be used when shopping cart service is not called, for example, pairing outside of checkout flow.</p>
   * @param merchantInitializationRequest	the Merchant Initialization request.
   * @return 	the MerchantInitializationResponse.
   */
     public static MerchantInitializationResponse create(MerchantInitializationRequest merchantInitializationRequest){
			return create( merchantInitializationRequest, MasterCardApiConfig.config());
	}
 
 
 /**
   * Merchant Initialization Service
   * <p>This service is used to secure Lightbox connections between merchant and MasterPass. This service requires a request token (OAuthToken). This service call should be used when shopping cart service is not called, for example, pairing outside of checkout flow.</p>
   * @param merchantInitializationRequest	the Merchant Initialization request.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the MerchantInitializationResponse.
   */
     public static MerchantInitializationResponse create(MerchantInitializationRequest merchantInitializationRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/v6/merchant-initialization";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(merchantInitializationRequest);
	 
	 serviceRequest.contentType("application/xml");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",MerchantInitializationResponse.class);
	}
 
}
